/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMEAspectHandler;
import org.biojava.bio.seq.io.game12.GAMEDbxrefHandler;
import org.biojava.bio.seq.io.game12.GAMEFeatureSetHandler;
import org.biojava.bio.seq.io.game12.GAMEGeneHandler;
import org.biojava.bio.seq.io.game12.GAMEPropertyHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEAnnotationHandler
extends StAXFeatureHandler {
    private Set knownTypes;
    String annotationName;
    String annotationType;
    int annotationLocMin = Integer.MAX_VALUE;
    int annotationLocMax = Integer.MIN_VALUE;
    StrandedFeature.Template annotationTemplate;
    public static final StAXHandlerFactory GAME_ANNOTATION_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEAnnotationHandler(staxenv);
        }
    };

    GAMEAnnotationHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.knownTypesInitialiser();
        super.addHandler(new ElementRecognizer.ByLocalName("name"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new NameHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("type"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new TypeHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("gene"), GAMEGeneHandler.GAME_GENE_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("feature_set"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new FeatureSetHandler(staxenv);
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("dbxref"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new DbxrefHandler(staxenv);
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("aspect"), GAMEAspectHandler.GAME_ASPECT_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("property"), GAMEPropertyHandler.GAME_PROPERTY_HANDLER_FACTORY);
    }

    private void knownTypesInitialiser() {
        String[] types = new String[]{"gene", "tRNA", "snRNA", "pseudogene", "transposon", "snoRNA", "misc. non-coding RNA", "transposable_element", "miscellaneous curator's observation"};
        this.knownTypes = new HashSet();
        for (int i = 0; i < types.length; ++i) {
            this.knownTypes.add(types[i]);
        }
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.annotationTemplate = new StrandedFeature.Template();
            this.annotationTemplate.annotation = new SimpleAnnotation();
            String id = attrs.getValue("id");
            try {
                if (id != null) {
                    this.annotationTemplate.annotation.setProperty("id", id);
                }
            }
            catch (ChangeVetoException cve) {
                cve.printStackTrace();
                throw new SAXException("unexpected ChangeVetoException when setting id!");
            }
            this.listener.startFeature(this.annotationTemplate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEAnnotationHandler.");
        }
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        if (!this.knownTypes.contains(this.annotationType)) {
            System.err.println("<annotation> of type " + this.annotationType + " encountered when gene expected");
        }
        this.annotationTemplate.type = this.annotationType;
        this.annotationTemplate.source = "";
        this.annotationTemplate.location = new RangeLocation(this.annotationLocMin, this.annotationLocMax);
        try {
            this.listener.endFeature();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEAnnotationHandler.");
        }
    }

    private class TypeHandler
    extends StringElementHandlerBase {
        private TypeHandler() {
        }

        @Override
        protected void setStringValue(String s) {
            GAMEAnnotationHandler.this.annotationType = s.trim();
        }
    }

    private class NameHandler
    extends StringElementHandlerBase {
        private NameHandler() {
        }

        @Override
        protected void setStringValue(String s) {
            GAMEAnnotationHandler.this.annotationName = s.trim();
        }
    }

    private class DbxrefHandler
    extends GAMEDbxrefHandler {
        private DbxrefHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        @Override
        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            super.endElementHandler(nsURI, localName, qName, contentHandler);
            try {
                this.listener.addFeatureProperty("dbxref", "dbxref:" + this.db_xref_db + "//" + this.db_xref_id);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                throw new SAXException("unexpected exception while add <dbxref> as a feature property.");
            }
        }
    }

    private class FeatureSetHandler
    extends GAMEFeatureSetHandler {
        private FeatureSetHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        @Override
        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            super.endElementHandler(nsURI, localName, qName, contentHandler);
            GAMEAnnotationHandler.this.annotationTemplate.strand = this.transcriptStrand;
            GAMEAnnotationHandler.this.annotationLocMin = Math.min(GAMEAnnotationHandler.this.annotationLocMin, this.transcript.getMin());
            GAMEAnnotationHandler.this.annotationLocMax = Math.max(GAMEAnnotationHandler.this.annotationLocMax, this.transcript.getMax());
            if (GAMEAnnotationHandler.this.annotationTemplate.strand == null) {
                GAMEAnnotationHandler.this.annotationTemplate.strand = this.transcriptStrand;
            } else if (GAMEAnnotationHandler.this.annotationTemplate.strand != this.transcriptStrand) {
                System.err.println("inconsistent strand info from transcripts.");
            }
        }
    }
}

