/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.distributed;

import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.distributed.DistDataSource;

public class SequenceDBDataSource
implements DistDataSource {
    private SequenceDB db;

    public SequenceDBDataSource(SequenceDB seqDB) {
        this.db = seqDB;
    }

    @Override
    public boolean hasSequence(String id) throws BioException {
        return this.db.ids().contains(id);
    }

    @Override
    public boolean hasFeatures(String id) throws BioException {
        return this.hasSequence(id);
    }

    @Override
    public FeatureHolder getFeatures(FeatureFilter ff) throws BioException {
        throw new BioException();
    }

    @Override
    public FeatureHolder getFeatures(String id, FeatureFilter ff, boolean recurse) throws BioException {
        Sequence fh;
        try {
            fh = this.db.getSequence(id);
        }
        catch (IllegalIDException ex) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (!recurse && FilterUtils.areProperSubset(FeatureFilter.all, ff)) {
            return fh;
        }
        return fh.filter(ff, recurse);
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        return this.db.getSequence(id);
    }

    @Override
    public Set ids(boolean topLevel) throws BioException {
        return this.db.ids();
    }
}

