/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.Serializable;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.utils.ChangeVetoException;

public class AnnotatedSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final SequenceDB parent;
    private final SequenceAnnotator annotator;

    public AnnotatedSequenceDB(SequenceDB parent, SequenceAnnotator a) {
        this.parent = parent;
        this.annotator = a;
    }

    public SequenceDB getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.parent.getName() + " (" + this.annotator.toString() + ")";
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        return this.doAnnotation(this.parent.getSequence(id));
    }

    @Override
    public Set ids() {
        return this.parent.ids();
    }

    @Override
    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            SequenceIterator pi;
            {
                this.pi = AnnotatedSequenceDB.this.parent.sequenceIterator();
            }

            @Override
            public boolean hasNext() {
                return this.pi.hasNext();
            }

            @Override
            public Sequence nextSequence() throws BioException {
                return AnnotatedSequenceDB.this.doAnnotation(this.pi.nextSequence());
            }
        };
    }

    protected Sequence doAnnotation(Sequence seq) throws BioException {
        try {
            return this.annotator.annotate(seq);
        }
        catch (IllegalAlphabetException ex) {
            throw new BioException("Couldn't apply annotator " + this.annotator.toString() + " to " + seq.getURN(), ex);
        }
        catch (ChangeVetoException cve) {
            throw new BioException("Couldn't apply annotator " + this.annotator.toString() + " to " + seq.getURN(), cve);
        }
    }
}

