/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.BioStoreFactory;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.bio.program.tagvalue.Indexer;
import org.biojava.bio.program.tagvalue.LineSplitParser;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.ValueChanger;
import org.biojava.bio.seq.io.SeqIOConstants;
import org.biojava.utils.CommitFailure;
import org.biojava.utils.ParserException;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RAF;
import org.biojava.utils.lsid.LifeScienceIdentifier;

public class IndexTools {
    private IndexTools() {
    }

    public static void indexFasta(String name, File location, File[] seqFiles, int alphabetIdentifier) throws FileNotFoundException, IOException, ParserException, BioException {
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreName(name);
        switch (alphabetIdentifier) {
            case 131072: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_FASTA_DNA);
                break;
            }
            case 262144: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_FASTA_RNA);
                break;
            }
            case 524288: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_FASTA_AA);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown alphabet identifier '" + alphabetIdentifier + "'");
            }
        }
        IndexTools._indexFasta(bsf, location, seqFiles);
    }

    public static void indexEmbl(String name, File location, File[] seqFiles, int alphabetIdentifier) throws FileNotFoundException, IOException, ParserException, BioException {
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreName(name);
        switch (alphabetIdentifier) {
            case 131072: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_EMBL_DNA);
                break;
            }
            case 262144: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_EMBL_RNA);
                break;
            }
            case 524288: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_EMBL_AA);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown alphabet identifier '" + alphabetIdentifier + "'");
            }
        }
        IndexTools._indexEmblLike(bsf, location, seqFiles);
    }

    public static void indexGenbank(String name, File location, File[] seqFiles, int alphabetIdentifier) throws FileNotFoundException, IOException, ParserException, BioException {
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreName(name);
        switch (alphabetIdentifier) {
            case 131072: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_GENBANK_DNA);
                break;
            }
            case 262144: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_GENBANK_RNA);
                break;
            }
            case 524288: {
                bsf.setSequenceFormat(SeqIOConstants.LSID_GENBANK_AA);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown alphabet identifier '" + alphabetIdentifier + "'");
            }
        }
        IndexTools._indexGenbank(bsf, location, seqFiles);
    }

    public static void indexSwissprot(String name, File location, File[] seqFiles) throws FileNotFoundException, IOException, ParserException, BioException {
        BioStoreFactory bsf = new BioStoreFactory();
        bsf.setStoreName(name);
        bsf.setSequenceFormat(LifeScienceIdentifier.valueOf("open-bio.org", "swiss", "protein"));
        IndexTools._indexEmblLike(bsf, location, seqFiles);
    }

    private static void _indexFasta(BioStoreFactory bsf, File location, File[] seqFiles) throws FileNotFoundException, IOException, BioException {
        bsf.setPrimaryKey("ID");
        bsf.setStoreLocation(location);
        bsf.addKey("ID", 10);
        BioStore store = bsf.createBioStore();
        for (int i = 0; i < seqFiles.length; ++i) {
            long newOffset = 0L;
            long oldOffset = 0L;
            RAF raf = new RAF(seqFiles[i], "r");
            HashMap map = new HashMap();
            CountedBufferedReader reader = new CountedBufferedReader(new FileReader(raf.getFile()));
            String id = "";
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (newOffset > 0L) {
                        store.writeRecord(raf, oldOffset, (int)(newOffset - oldOffset), id, map);
                        oldOffset = newOffset;
                    }
                    newOffset = reader.getFilePointer();
                    int delimeter = line.indexOf(" ");
                    if (delimeter < 0) {
                        id = line.substring(1);
                        continue;
                    }
                    id = line.substring(1, delimeter);
                    continue;
                }
                newOffset = reader.getFilePointer();
            }
            store.writeRecord(raf, oldOffset, (int)(newOffset - oldOffset), id, map);
        }
        try {
            store.commit();
        }
        catch (CommitFailure ne) {
            throw new BioException("Failed to commit new index to file", ne);
        }
    }

    private static void _indexEmblLike(BioStoreFactory bsf, File location, File[] seqFiles) throws FileNotFoundException, IOException, ParserException, BioException {
        bsf.setPrimaryKey("ID");
        bsf.setStoreLocation(location);
        bsf.addKey("AC", 10);
        bsf.addKey("ID", 10);
        BioStore store = bsf.createBioStore();
        for (int i = 0; i < seqFiles.length; ++i) {
            Indexer indexer = new Indexer(seqFiles[i], store);
            indexer.setPrimaryKeyName("ID");
            indexer.addSecondaryKey("AC");
            ChangeTable changeTable = new ChangeTable();
            changeTable.setChanger("ID", new ChangeTable.Changer(){

                @Override
                public Object change(Object value) {
                    String s = (String)value;
                    int i = s.indexOf(" ");
                    if (i < 0) {
                        return s;
                    }
                    return s.substring(0, i);
                }
            });
            changeTable.setChanger("AC", new ChangeTable.Changer(){

                @Override
                public Object change(Object value) {
                    String s = (String)value;
                    int i = s.indexOf(";");
                    return s.substring(0, i);
                }
            });
            ValueChanger changer = new ValueChanger(indexer, changeTable);
            Parser parser = new Parser();
            while (parser.read(indexer.getReader(), LineSplitParser.EMBL, changer)) {
            }
        }
        try {
            store.commit();
        }
        catch (CommitFailure ne) {
            throw new BioException("Failed to commit new index to file", ne);
        }
    }

    private static void _indexGenbank(BioStoreFactory bsf, File location, File[] seqFiles) throws FileNotFoundException, IOException, ParserException, BioException {
        bsf.setPrimaryKey("LOCUS");
        bsf.setStoreLocation(location);
        bsf.addKey("LOCUS", 10);
        bsf.addKey("ACCESSION", 10);
        BioStore store = bsf.createBioStore();
        for (int i = 0; i < seqFiles.length; ++i) {
            Indexer indexer = new Indexer(seqFiles[i], store);
            indexer.setPrimaryKeyName("LOCUS");
            indexer.addSecondaryKey("ACCESSION");
            ChangeTable changeTable = new ChangeTable();
            changeTable.setChanger("LOCUS", new ChangeTable.Changer(){

                @Override
                public Object change(Object value) {
                    String s = (String)value;
                    int i = s.indexOf(" ");
                    if (i < 0) {
                        return s;
                    }
                    return s.substring(0, i);
                }
            });
            ValueChanger changer = new ValueChanger(indexer, changeTable);
            Parser parser = new Parser();
            while (parser.read(indexer.getReader(), LineSplitParser.GENBANK, changer)) {
            }
        }
        try {
            store.commit();
        }
        catch (CommitFailure ne) {
            throw new BioException("Failed to commit new index to file", ne);
        }
    }
}

