/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.SimilarityType;

public class SimpleOrthoPair
implements OrthoPair {
    private Orthologue first;
    private Orthologue second;
    private SimilarityType type;
    private double percentIdentity = 0.0;
    private String ref = null;

    public SimpleOrthoPair(Orthologue first, Orthologue second, SimilarityType type, double percentIdentity) {
        if (first == null || second == null) {
            throw new IllegalArgumentException();
        }
        if (type != SimilarityType.MULTIPLE && type != SimilarityType.TWIN) {
            throw new IllegalArgumentException();
        }
        if (first.getTaxonID() < second.getTaxonID()) {
            this.first = first;
            this.second = second;
        } else {
            this.first = second;
            this.second = first;
        }
        this.type = type;
        this.percentIdentity = percentIdentity;
    }

    public SimpleOrthoPair(Orthologue first, Orthologue second, String ref) {
        if (first == null || second == null) {
            throw new IllegalArgumentException();
        }
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        this.first = first;
        this.second = second;
        this.type = SimilarityType.CURATED;
    }

    @Override
    public Orthologue getFirstOrthologue() {
        return this.first;
    }

    @Override
    public Orthologue getSecondOrthologue() {
        return this.second;
    }

    @Override
    public SimilarityType getSimilarity() {
        return this.type;
    }

    @Override
    public double getPercentIdentity() {
        return this.percentIdentity;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OrthoPair)) {
            return false;
        }
        OrthoPair other = (OrthoPair)o;
        if (other.getFirstOrthologue().equals(this.first)) {
            return false;
        }
        if (other.getSecondOrthologue().equals(this.second)) {
            return false;
        }
        return other.getSimilarity() == this.type;
    }
}

