/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.CellCalculator;
import org.biojava.bio.dp.twohead.CellCalculatorFactory;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;

public class DPInterpreter
implements CellCalculatorFactory,
Serializable {
    private final DP dp;

    public DPInterpreter(DP dp) {
        this.dp = dp;
    }

    @Override
    public CellCalculator forwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Forward(this.dp, scoreType);
    }

    @Override
    public CellCalculator backwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Backward(this.dp, scoreType);
    }

    @Override
    public CellCalculator viterbi(ScoreType scoreType, BackPointer terminal) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Viterbi(this.dp, scoreType, terminal);
    }

    public static class Maker
    implements CellCalculatorFactoryMaker {
        @Override
        public CellCalculatorFactory make(DP dp) {
            return new DPInterpreter(dp);
        }
    }

    private class Viterbi
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final BackPointer TERMINAL_BP;
        private final State magicalState;

        public Viterbi(DP dp, ScoreType scoreType, BackPointer terminal) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.TERMINAL_BP = terminal;
            this.states = dp.getStates();
            this.transitions = dp.getForwardTransitions();
            this.transitionScores = dp.getForwardTransitionScores(scoreType);
            this.magicalState = dp.getModel().magicalState();
        }

        @Override
        public void initialize(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, true);
        }

        @Override
        public void calcCell(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, false);
        }

        public void _calcCell(Cell[][] cells, boolean initializationHack) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell curCell = cells[0][0];
            double[] curCol = curCell.scores;
            BackPointer[] curBPs = curCell.backPointers;
            double[] emissions = curCell.emissions;
            for (int l = 0; l < this.states.length; ++l) {
                State curState = this.states[l];
                try {
                    BackPointer[] oldBPs;
                    double[] sourceScores;
                    double weight;
                    if (initializationHack && curState instanceof EmissionState) {
                        if (curState == this.magicalState) {
                            curCol[l] = 0.0;
                            curBPs[l] = this.TERMINAL_BP;
                            continue;
                        }
                        curCol[l] = Double.NaN;
                        curBPs[l] = null;
                        continue;
                    }
                    if (!(curState instanceof EmissionState)) {
                        weight = 0.0;
                        sourceScores = curCol;
                        oldBPs = curBPs;
                    } else {
                        weight = emissions[l];
                        if (weight == Double.NEGATIVE_INFINITY || Double.isNaN(weight)) {
                            curCol[l] = Double.NaN;
                            curBPs[l] = null;
                            continue;
                        }
                        int[] advance = ((EmissionState)curState).getAdvance();
                        Cell oldCell = cells[advance[0]][advance[1]];
                        sourceScores = oldCell.scores;
                        oldBPs = oldCell.backPointers;
                    }
                    double score = Double.NEGATIVE_INFINITY;
                    int[] tr = this.transitions[l];
                    double[] trs = this.transitionScores[l];
                    int bestK = -1;
                    for (int kc = 0; kc < tr.length; ++kc) {
                        double t;
                        double newScore;
                        int k = tr[kc];
                        double sk = sourceScores[k];
                        if (sk == Double.NEGATIVE_INFINITY || Double.isNaN(sk) || !((newScore = (t = trs[kc]) + sk) > score)) continue;
                        score = newScore;
                        bestK = k;
                    }
                    if (bestK != -1) {
                        curCol[l] = weight + score;
                        try {
                            State s = this.states[l];
                            curBPs[l] = new BackPointer(s, oldBPs[bestK], curCol[l]);
                            continue;
                        }
                        catch (Throwable t) {
                            throw new BioError("Couldn't generate backpointer for " + this.states[l].getName() + " back to " + this.states[bestK].getName(), t);
                        }
                    }
                    curBPs[l] = null;
                    curCol[l] = Double.NaN;
                    continue;
                }
                catch (Exception e) {
                    throw new BioError("Problem with state " + l + " -> " + this.states[l].getName(), e);
                }
                catch (BioError e) {
                    throw new BioError("Error  with state " + l + " -> " + this.states[l].getName(), e);
                }
            }
            initializationHack = false;
        }
    }

    private static class Backward
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final State magicalState;

        public Backward(DP dp, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.states = dp.getStates();
            this.transitions = dp.getBackwardTransitions();
            this.transitionScores = dp.getBackwardTransitionScores(scoreType);
            this.magicalState = dp.getModel().magicalState();
        }

        @Override
        public void initialize(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, true);
        }

        @Override
        public void calcCell(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, false);
        }

        public void _calcCell(Cell[][] cells, boolean initializationHack) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell curCell = cells[0][0];
            double[] curCol = curCell.scores;
            block0: for (int l = this.states.length - 1; l >= 0; --l) {
                State curState = this.states[l];
                if (initializationHack && curState instanceof EmissionState) {
                    if (curState == this.magicalState) {
                        curCol[l] = 0.0;
                        continue;
                    }
                    curCol[l] = Double.NaN;
                    continue;
                }
                int[] tr = this.transitions[l];
                double[] trs = this.transitionScores[l];
                double[] sourceScores = new double[tr.length];
                for (int ci = 0; ci < tr.length; ++ci) {
                    double weight;
                    Cell targetCell;
                    int destI = tr[ci];
                    State destS = this.states[destI];
                    if (destS instanceof EmissionState) {
                        int[] advance = ((EmissionState)destS).getAdvance();
                        targetCell = cells[advance[0]][advance[1]];
                        weight = targetCell.emissions[destI];
                        if (Double.isNaN(weight)) {
                            curCol[l] = Double.NaN;
                            continue block0;
                        }
                    } else {
                        targetCell = curCell;
                        weight = 0.0;
                    }
                    sourceScores[ci] = targetCell.scores[destI] + weight;
                }
                double constant = Double.NaN;
                double score = 0.0;
                for (int ci = 0; ci < tr.length; ++ci) {
                    double sk;
                    double skc = sourceScores[ci];
                    if (skc == Double.NEGATIVE_INFINITY || Double.isNaN(skc)) continue;
                    if (Double.isNaN(constant)) {
                        constant = skc;
                    }
                    if (Double.isNaN(sk = trs[ci]) || sk == Double.NEGATIVE_INFINITY) continue;
                    score += Math.exp(skc + sk - constant);
                }
                curCol[l] = Double.isNaN(constant) ? Double.NaN : Math.log(score) + constant;
            }
        }
    }

    private static class Forward
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final State magicalState;

        public Forward(DP dp, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.states = dp.getStates();
            this.transitions = dp.getForwardTransitions();
            this.transitionScores = dp.getForwardTransitionScores(scoreType);
            this.magicalState = dp.getModel().magicalState();
        }

        @Override
        public void initialize(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, true);
        }

        @Override
        public void calcCell(Cell[][] cells) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cells, false);
        }

        public void _calcCell(Cell[][] cells, boolean initializationHack) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell curCell = cells[0][0];
            double[] curCol = curCell.scores;
            double[] emissions = curCell.emissions;
            for (int l = 0; l < this.states.length; ++l) {
                State curState = this.states[l];
                try {
                    double[] sourceScores;
                    double weight;
                    if (initializationHack && curState instanceof EmissionState) {
                        if (curState == this.magicalState) {
                            curCol[l] = 0.0;
                            continue;
                        }
                        curCol[l] = Double.NaN;
                        continue;
                    }
                    if (!(curState instanceof EmissionState)) {
                        weight = 0.0;
                        sourceScores = curCol;
                    } else {
                        weight = emissions[l];
                        if (weight == Double.NEGATIVE_INFINITY || Double.isNaN(weight)) {
                            curCol[l] = Double.NaN;
                            continue;
                        }
                        int[] advance = ((EmissionState)curState).getAdvance();
                        sourceScores = cells[advance[0]][advance[1]].scores;
                    }
                    int[] tr = this.transitions[l];
                    double[] trs = this.transitionScores[l];
                    double constant = Double.NaN;
                    double score = 0.0;
                    for (int ci = 0; ci < tr.length; ++ci) {
                        double sk;
                        int trc = tr[ci];
                        double trSc = sourceScores[trc];
                        if (Double.isNaN(trSc) || trSc == Double.NEGATIVE_INFINITY) continue;
                        if (Double.isNaN(constant)) {
                            constant = trSc;
                        }
                        if (Double.isNaN(sk = trs[ci]) || sk == Double.NEGATIVE_INFINITY) continue;
                        score += Math.exp(trSc + sk - constant);
                    }
                    if (Double.isNaN(constant)) {
                        curCol[l] = Double.NaN;
                        continue;
                    }
                    curCol[l] = weight + Math.log(score) + constant;
                    continue;
                }
                catch (Exception e) {
                    throw new BioError("Problem with state " + l + " -> " + this.states[l].getName(), e);
                }
                catch (BioError e) {
                    throw new BioError("Error  with state " + l + " -> " + this.states[l].getName(), e);
                }
            }
        }
    }
}

