/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.AnyPropertyConstraint;
import org.biojava.bio.NonePropertyConstraint;

public interface PropertyConstraint {
    public static final PropertyConstraint ANY = new AnyPropertyConstraint();
    public static final PropertyConstraint NONE = new NonePropertyConstraint();

    public boolean accept(Object var1);

    public boolean subConstraintOf(PropertyConstraint var1);

    public static class Or
    implements PropertyConstraint {
        private PropertyConstraint c1;
        private PropertyConstraint c2;

        public Or(PropertyConstraint c1, PropertyConstraint c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public PropertyConstraint getChild1() {
            return this.c1;
        }

        public PropertyConstraint getChild2() {
            return this.c2;
        }

        @Override
        public boolean accept(Object object) {
            return this.c1.accept(object) || this.c2.accept(object);
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint pc) {
            return this.c1.subConstraintOf(pc) || this.c2.subConstraintOf(pc);
        }

        public String toString() {
            return "Or(" + this.c1 + ", " + this.c2 + ")";
        }
    }

    public static class And
    implements PropertyConstraint {
        private PropertyConstraint c1;
        private PropertyConstraint c2;

        public And(PropertyConstraint c1, PropertyConstraint c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public PropertyConstraint getChild1() {
            return this.c1;
        }

        public PropertyConstraint getChild2() {
            return this.c2;
        }

        @Override
        public boolean accept(Object object) {
            return this.c1.accept(object) && this.c2.accept(object);
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint pc) {
            return this.c1.subConstraintOf(pc) && this.c2.subConstraintOf(pc);
        }

        public String toString() {
            return "And(" + this.c1 + ", " + this.c2 + ")";
        }
    }

    public static class Enumeration
    implements PropertyConstraint {
        private Set values;

        public Enumeration(Set values) {
            this.values = values;
        }

        public Enumeration(Object[] values) {
            this.values = new HashSet();
            for (int i = 0; i < values.length; ++i) {
                this.values.add(values[i]);
            }
        }

        public Set getValues() {
            return this.values;
        }

        @Override
        public boolean accept(Object value) {
            return this.values.contains(value);
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint subConstraint) {
            if (subConstraint instanceof Enumeration) {
                Enumeration subE = (Enumeration)subConstraint;
                return this.values.containsAll(subE.getValues());
            }
            if (subConstraint instanceof ExactValue) {
                return this.accept(((ExactValue)subConstraint).getValue());
            }
            return false;
        }

        public String toString() {
            return "Enumeration:" + this.values;
        }
    }

    public static class ExactValue
    implements PropertyConstraint {
        private Object value;

        public ExactValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean accept(Object obj) {
            return this.value.equals(obj);
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint pc) {
            if (pc instanceof ExactValue) {
                return this.value.equals(((ExactValue)pc).getValue());
            }
            if (pc instanceof Enumeration) {
                Enumeration e = (Enumeration)pc;
                return e.getValues().size() == 1 && e.accept(this.value);
            }
            return false;
        }

        public String toString() {
            return "ExactValue: " + this.value;
        }
    }

    public static class ByAnnotationType
    implements PropertyConstraint {
        private AnnotationType annType;

        public ByAnnotationType(AnnotationType annType) {
            this.annType = annType;
        }

        public AnnotationType getAnnotationType() {
            return this.annType;
        }

        @Override
        public boolean accept(Object value) {
            if (value instanceof Annotation) {
                return this.annType.instanceOf((Annotation)value);
            }
            return false;
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint subConstraint) {
            if (subConstraint instanceof ByAnnotationType) {
                ByAnnotationType at = (ByAnnotationType)subConstraint;
                return this.annType.subTypeOf(at.getAnnotationType());
            }
            return false;
        }

        public String toString() {
            return "AnnotationType:" + this.annType.getProperties();
        }
    }

    public static class ByClass
    implements PropertyConstraint {
        private Class cl;

        public ByClass(Class cl) {
            this.cl = cl;
        }

        public Class getPropertyClass() {
            return this.cl;
        }

        @Override
        public boolean accept(Object value) {
            return this.cl.isInstance(value);
        }

        @Override
        public boolean subConstraintOf(PropertyConstraint subConstraint) {
            if (subConstraint instanceof ByClass) {
                ByClass sc = (ByClass)subConstraint;
                return this.cl.isAssignableFrom(sc.getPropertyClass());
            }
            if (subConstraint instanceof Enumeration) {
                Set values = ((Enumeration)subConstraint).getValues();
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    if (this.accept(i.next())) continue;
                    return false;
                }
                return true;
            }
            if (subConstraint instanceof ExactValue) {
                return this.accept(((ExactValue)subConstraint).getValue());
            }
            return false;
        }

        public String toString() {
            return "Class:" + this.cl.toString();
        }
    }
}

