/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.utils.ParserException;

public class AnnotationChanger
extends AbstractAnnotation {
    private final Annotation wrapped;
    private final ChangeTable changer;
    private final Map properties;

    public AnnotationChanger(Annotation wrapped, ChangeTable changer) {
        this.wrapped = wrapped;
        this.changer = changer;
        this.properties = new MappedHash();
    }

    public Annotation getWrapped() {
        return this.wrapped;
    }

    public ChangeTable getChanger() {
        return this.changer;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public boolean propertiesAllocated() {
        return true;
    }

    private class WrappedSet
    extends AbstractSet {
        private Set entrySet;

        public WrappedSet(Set entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator i;
                {
                    this.i = WrappedSet.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    final Map.Entry entry = (Map.Entry)this.i.next();
                    return new Map.Entry(){

                        public Object getKey() {
                            return entry.getKey();
                        }

                        public Object getValue() {
                            try {
                                return AnnotationChanger.this.changer.change(this.getKey(), entry.getValue());
                            }
                            catch (ParserException pe) {
                                throw new BioError(pe);
                            }
                        }

                        public Object setValue(Object value) {
                            return entry.setValue(value);
                        }
                    };
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }
    }

    private class MappedHash
    extends AbstractMap {
        private MappedHash() {
        }

        @Override
        public int size() {
            return AnnotationChanger.this.wrapped.asMap().size();
        }

        @Override
        public Set entrySet() {
            return new WrappedSet(AnnotationChanger.this.wrapped.asMap().entrySet());
        }
    }
}

