/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.index;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class H2Connection {
    Connection conn = null;

    public H2Connection(String databasePath) throws SQLException, IOException {
        this.init(new File(databasePath), true);
    }

    public H2Connection(String databasePath, boolean isWritable) throws SQLException, IOException {
        this.init(new File(databasePath), isWritable);
    }

    public H2Connection(File databaseFile) throws SQLException, IOException {
        this.init(databaseFile, true);
    }

    private void init(File databaseFile, boolean isWritable) throws SQLException, IOException {
        this.conn = this.getConnection(databaseFile, isWritable);
    }

    public Connection getConn() {
        return this.conn;
    }

    private void loadH2Driver() throws IOException {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Connection getConnection(File databaseFile, boolean isWritable) throws SQLException, IOException {
        this.loadH2Driver();
        String dbPath = databaseFile.getCanonicalPath().replace(".h2.db", "");
        String url = isWritable ? "jdbc:h2:file:" + dbPath + ";IGNORECASE=TRUE;FILE_LOCK=SERIALIZED;" : "jdbc:h2:file:" + dbPath + ";IGNORECASE=TRUE;FILE_LOCK=NO;IFEXISTS=TRUE;LOG=0;UNDO_LOG=0;LOCK_MODE=0;ACCESS_MODE_DATA=r;TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0;";
        Connection conn = DriverManager.getConnection(url, "sa", "");
        return conn;
    }

    public List<String> getTables(Connection dbConn) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        String query = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'TABLE'";
        Statement stmt = dbConn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            tableNames.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        stmt.close();
        return tableNames;
    }

    public void createTable(boolean isKeyInteger, int maxKeyLength, Connection dbConn) throws SQLException {
        String SQL = "CREATE TABLE Indexer (" + (isKeyInteger ? "Key BIGINT," : "Key VARCHAR(" + maxKeyLength + "), ") + "FilePos BIGINT)";
        Statement stmt = dbConn.createStatement();
        stmt.execute(SQL);
        stmt.close();
    }

    public void createTableIndex(Connection dbConn) throws SQLException {
        String SQL = "CREATE INDEX keyIndex ON Indexer (Key);";
        Statement stmt = dbConn.createStatement();
        stmt.execute("CREATE INDEX keyIndex ON Indexer (Key);");
        stmt.close();
    }
}

