/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.history.History;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class TabixSearchHistoryPipe
extends AbstractPipe<History, History> {
    private TabixSearchPipe mTabixSearchPipe;
    private History history = null;
    private TabixReader.Iterator tabixRecords = null;

    public TabixSearchHistoryPipe(String tabixDataFile) throws IOException {
        this(tabixDataFile, 0, 0);
    }

    public TabixSearchHistoryPipe(String tabixDataFile, int minBPExtend, int maxBPExtend) throws IOException {
        this.mTabixSearchPipe = new TabixSearchPipe(tabixDataFile, minBPExtend, maxBPExtend);
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            String tabixRecord = null;
            this.requery();
            tabixRecord = this.tabixRecords.next();
            if (tabixRecord != null) {
                return this.addTabixResultsColumnsToHistory(this.history, tabixRecord);
            }
            this.tabixRecords = null;
            this.history = null;
            this.requery();
            tabixRecord = this.tabixRecords.next();
            if (tabixRecord != null) {
                return this.addTabixResultsColumnsToHistory(this.history, tabixRecord);
            }
            throw new NoSuchElementException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new NoSuchElementException();
        }
    }

    private void requery() throws NoSuchElementException, IOException {
        if (this.tabixRecords == null) {
            if (this.history == null) {
                if (this.starts.hasNext()) {
                    this.history = (History)this.starts.next();
                } else {
                    throw new NoSuchElementException();
                }
            }
            String json = (String)this.history.get(this.history.size() - 1);
            this.tabixRecords = this.mTabixSearchPipe.query(json);
        }
    }

    private History addTabixResultsColumnsToHistory(History history, String tabixRecord) {
        String[] tabixColumns;
        for (String col : tabixColumns = tabixRecord.split("\t")) {
            history.add(col);
        }
        return history;
    }
}

