/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.exceptions.InvalidJSONException;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillPipe
extends AbstractPipe<History, History> {
    private static Logger sLogger = LoggerFactory.getLogger(DrillPipe.class);
    private boolean isKeepJSON = false;
    private String[] drillPaths;
    private ArrayList<JsonPath> compiledPaths;
    private int drillColumnOneBased = -1;
    private long lineNum = 0L;
    public static String ARRAY_DELIMITER_DEFAULT = "|";
    private String arrayDelimiter = ARRAY_DELIMITER_DEFAULT;
    private boolean isSkipNullsAndDotsInArrays = false;
    JsonProvider jsonProvider5 = new JsonOrgJsonProvider();
    Configuration config = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider(this.jsonProvider5).build();

    public DrillPipe(boolean keepJSON, String[] paths) {
        this.isKeepJSON = keepJSON;
        this.drillPaths = paths;
        this.setupPaths();
    }

    public DrillPipe(boolean keepJSON, String[] paths, int drillColumn) {
        this.isKeepJSON = keepJSON;
        this.drillPaths = paths;
        this.drillColumnOneBased = drillColumn;
        this.setupPaths();
    }

    public DrillPipe(boolean keepJSON, String[] paths, int drillColumn, String arrayDelimiter, boolean isSkipNullsAndDotsInArrays) {
        this.isKeepJSON = keepJSON;
        this.drillPaths = paths;
        this.drillColumnOneBased = drillColumn;
        this.arrayDelimiter = arrayDelimiter;
        this.isSkipNullsAndDotsInArrays = isSkipNullsAndDotsInArrays;
        this.setupPaths();
    }

    private void setupPaths() {
        this.compiledPaths = new ArrayList();
        for (int i = 0; i < this.drillPaths.length; ++i) {
            JsonPath jsonPath = JsonPath.compile((String)this.drillPaths[i], (Predicate[])new Predicate[0]);
            this.compiledPaths.add(jsonPath);
        }
    }

    protected History processNextStart() throws NoSuchElementException, InvalidJSONException {
        History history = (History)this.starts.next();
        ++this.lineNum;
        int drillColumnZeroBased = this.getDrillColumnZeroBased(history, this.drillColumnOneBased);
        String json = ((String)history.remove(drillColumnZeroBased)).trim();
        this.throwExceptionIfColNotJson(json);
        for (int i = 0; i < this.compiledPaths.size(); ++i) {
            JsonPath jsonPath = this.compiledPaths.get(i);
            String columnName = this.getColumnName(history, i);
            this.addJsonValueToHistory(history, json, jsonPath, columnName);
        }
        if (this.isKeepJSON) {
            history.add(json);
        }
        return history;
    }

    private String getColumnName(History history, int compiledPathsIndex) {
        if (history.getMetaData() == null) {
            return "";
        }
        List<ColumnMetaData> colMeta = history.getMetaData().getColumns();
        int colMetaIdx = colMeta.size() - this.compiledPaths.size() + compiledPathsIndex;
        if (this.isKeepJSON) {
            --colMetaIdx;
        }
        if (colMetaIdx >= 0 && colMetaIdx < colMeta.size()) {
            return colMeta.get(colMetaIdx).getColumnName();
        }
        return "";
    }

    private void addJsonValueToHistory(History history, String json, JsonPath jsonPath, String columnName) {
        String val = ".";
        try {
            Object o = jsonPath.read(json, this.config);
            if (o == null) {
                val = ".";
            } else if (o instanceof JSONArray) {
                if (this.lineNum == 1L) {
                    this.addDelimiterToHeaderMetadata(history, columnName);
                }
                val = this.compressJsonArray((JSONArray)o);
            } else {
                val = o.toString();
            }
        }
        catch (InvalidPathException e) {
            val = ".";
        }
        catch (IndexOutOfBoundsException e) {
            val = ".";
        }
        catch (JsonPathException e) {
            val = ".";
        }
        history.add(val);
    }

    private void addDelimiterToHeaderMetadata(History history, String columnName) {
        if (history.getMetaData() == null) {
            return;
        }
        AddMetadataLines addMeta = new AddMetadataLines();
        int headerRowNum = addMeta.getHistoryMetadataLine4HeaderValue(history, columnName);
        if (headerRowNum == -1) {
            return;
        }
        String biorMetaLine = history.getMetaData().getOriginalHeader().get(headerRowNum);
        LinkedHashMap<String, String> attrs = addMeta.parseHeaderLine(biorMetaLine);
        attrs.put(AddMetadataLines.BiorMetaControlledVocabulary.DELIMITER.toString(), this.arrayDelimiter);
        String numberAttr = attrs.get(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString());
        if (numberAttr == null || "0".equals(numberAttr) || "1".equals(numberAttr)) {
            attrs.put(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString(), ".");
        }
        String biorHeaderLine = addMeta.buildHeaderLine(attrs);
        history.getMetaData().getOriginalHeader().set(headerRowNum, biorHeaderLine);
    }

    private void throwExceptionIfColNotJson(String json) {
        if (!json.startsWith("{") && !json.endsWith("}")) {
            throw new InvalidJSONException("A column input to Drill that should be JSON was not JSON, I can't Drill non-JSON columns: " + this.drillColumnOneBased + " : " + json);
        }
    }

    private int getDrillColumnZeroBased(History history, int drillColOneBased) {
        boolean isColOutOfRange;
        boolean bl = isColOutOfRange = drillColOneBased == 0 || drillColOneBased > history.size() || drillColOneBased < -history.size();
        if (isColOutOfRange) {
            throw new InvalidPipeInputException("Invalid drill column input: " + drillColOneBased + " of " + history.size() + " columns.", (Pipe)this);
        }
        if (drillColOneBased > 0) {
            return drillColOneBased - 1;
        }
        return history.size() + drillColOneBased;
    }

    private String compressJsonArray(JSONArray jsonArray) {
        StringBuilder compressedArray = new StringBuilder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            boolean isNullAndSkipped;
            Object obj = jsonArray.get(i);
            String val = obj == JSONObject.NULL || obj == null || obj.toString().trim().equals(".") ? "." : obj.toString().trim();
            boolean bl = isNullAndSkipped = this.isSkipNullsAndDotsInArrays && val.equals(".");
            if (val.contains(this.arrayDelimiter)) {
                throw new InvalidJSONException("Error: the delimiter '" + this.arrayDelimiter + "' was found within one of the array values that was drilled: '" + val + "'");
            }
            if (isNullAndSkipped) continue;
            String delim = compressedArray.length() > 0 ? this.arrayDelimiter : "";
            compressedArray.append(delim).append(val);
        }
        String arrayStr = compressedArray.toString().trim();
        if (arrayStr.length() == 0) {
            arrayStr = ".";
        }
        return arrayStr;
    }
}

