/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.sqlite;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.sqlite.SQLiteIndex;
import com.googlecode.cqengine.index.sqlite.support.DBUtils;
import com.googlecode.cqengine.index.support.PartialSortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.NonHeapTypeIndex;
import com.googlecode.cqengine.query.Query;

public class PartialSQLiteIndex<A extends Comparable<A>, O, K>
extends PartialSortedKeyStatisticsAttributeIndex<A, O>
implements NonHeapTypeIndex {
    final SimpleAttribute<O, K> primaryKeyAttribute;
    final SimpleAttribute<K, O> foreignKeyAttribute;
    final String tableNameSuffix;

    protected PartialSQLiteIndex(Attribute<O, A> attribute, SimpleAttribute<O, K> primaryKeyAttribute, SimpleAttribute<K, O> foreignKeyAttribute, Query<O> filterQuery) {
        super(attribute, filterQuery);
        this.primaryKeyAttribute = primaryKeyAttribute;
        this.foreignKeyAttribute = foreignKeyAttribute;
        this.tableNameSuffix = "_partial_" + DBUtils.sanitizeForTableName(filterQuery.toString());
    }

    @Override
    protected SortedKeyStatisticsAttributeIndex<A, O> createBackingIndex() {
        return new SQLiteIndex(this.attribute, this.primaryKeyAttribute, this.foreignKeyAttribute, this.tableNameSuffix){

            @Override
            public Index getEffectiveIndex() {
                return PartialSQLiteIndex.this.getEffectiveIndex();
            }
        };
    }

    public static <A extends Comparable<A>, O, K> PartialSQLiteIndex<A, O, K> onAttributeWithFilterQuery(Attribute<O, A> attribute, SimpleAttribute<O, K> primaryKeyAttribute, SimpleAttribute<K, O> foreignKeyAttribute, Query<O> filterQuery) {
        return new PartialSQLiteIndex<A, O, K>(attribute, primaryKeyAttribute, foreignKeyAttribute, filterQuery);
    }
}

