/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.sequence;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class Bed2SequencePipe
extends AbstractPipe<ArrayList<String>, ArrayList<String>> {
    TabixSearchPipe mTabixSearch;
    private int mMaxBpCol = -1;
    private boolean mIsUseJsonCol = false;
    private JsonPath mChromJsonPath;
    private JsonPath mMinBpJsonPath;
    private JsonPath mMaxBpJsonPath;
    int start = 0;
    int end = 0;
    String result = "";
    TabixReader.Iterator records;

    public Bed2SequencePipe(String tabixDataFile) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
    }

    public Bed2SequencePipe(String tabixDataFile, int column) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
        this.mMaxBpCol = column;
    }

    public Bed2SequencePipe(String tabixDataFile, int column, boolean isUseJson) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
        this.mMaxBpCol = column;
        this.mIsUseJsonCol = isUseJson;
        this.mChromJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Predicate[])new Predicate[0]);
        this.mMinBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Predicate[])new Predicate[0]);
        this.mMaxBpJsonPath = JsonPath.compile((String)CoreAttributes._maxBP.toString(), (Predicate[])new Predicate[0]);
    }

    public Bed2SequencePipe(String tabixDataFile, boolean isUseJson) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
        this.mIsUseJsonCol = isUseJson;
        this.mChromJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Predicate[])new Predicate[0]);
        this.mMinBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Predicate[])new Predicate[0]);
        this.mMaxBpJsonPath = JsonPath.compile((String)CoreAttributes._maxBP.toString(), (Predicate[])new Predicate[0]);
    }

    public ArrayList<String> processNextStart() throws NoSuchElementException {
        try {
            boolean malformed = false;
            String subsequence = ".";
            String tabixQuery = "*";
            ArrayList history = (ArrayList)this.starts.next();
            try {
                tabixQuery = this.getTabixQueryString(history);
            }
            catch (Exception e) {
                malformed = true;
            }
            if (!malformed) {
                subsequence = this.getSequence(tabixQuery);
            }
            history.add(subsequence);
            return history;
        }
        catch (IOException ex) {
            throw new NoSuchElementException();
        }
    }

    private String getSequence(String tabixQuery) throws NumberFormatException, IOException {
        StringBuilder subsequence = new StringBuilder();
        this.records = this.mTabixSearch.tquery(tabixQuery);
        if (this.records == null) {
            return ".";
        }
        String rec = null;
        boolean isFirst = true;
        int seqEndPos = 0;
        while ((rec = this.records.next()) != null) {
            String[] split = rec.split("\t");
            String seq = split[3];
            if (isFirst) {
                int numToTrimOffFront = this.getMin(tabixQuery) - Integer.parseInt(split[1]);
                seq = seq.substring(numToTrimOffFront);
                isFirst = false;
            }
            subsequence.append(seq);
            seqEndPos = Integer.parseInt(split[2]);
        }
        if (seqEndPos == 0) {
            return ".";
        }
        int numToTrimOffEnd = seqEndPos - this.getMax(tabixQuery);
        return subsequence.substring(0, subsequence.length() - numToTrimOffEnd);
    }

    private String getTabixQueryString(ArrayList<String> history) throws ArrayIndexOutOfBoundsException {
        String query = "";
        if (this.mIsUseJsonCol) {
            int max;
            int min;
            String lastColStr = history.get(history.size() + this.mMaxBpCol);
            String chr = (String)this.mChromJsonPath.read(lastColStr);
            Object minBpObj = this.mMinBpJsonPath.read(lastColStr);
            int n = min = minBpObj instanceof String ? Integer.parseInt((String)minBpObj) : (Integer)minBpObj;
            if (min < 1) {
                throw new ArrayIndexOutOfBoundsException("_minBP can not be 0 or less!");
            }
            Object maxBpObj = this.mMaxBpJsonPath.read(lastColStr);
            int n2 = max = maxBpObj instanceof String ? Integer.parseInt((String)maxBpObj) : (Integer)maxBpObj;
            if (max < 1) {
                throw new ArrayIndexOutOfBoundsException("_maxBP can not be 0 or less!");
            }
            query = chr + ":" + min + "-" + max;
        } else {
            String chr = history.get(history.size() - 2 + this.mMaxBpCol);
            String min = history.get(history.size() - 1 + this.mMaxBpCol);
            String max = history.get(history.size() + this.mMaxBpCol);
            query = chr + ":" + min + "-" + max;
            if (max.equalsIgnoreCase("0") || min.equalsIgnoreCase("0")) {
                throw new ArrayIndexOutOfBoundsException("_minBP, _maxBP can not be 0 or less!" + query);
            }
        }
        return query;
    }

    private int getMin(String query) {
        return Integer.parseInt(query.substring(query.indexOf(":") + 1, query.indexOf("-")));
    }

    private int getMax(String query) {
        return Integer.parseInt(query.substring(query.indexOf("-") + 1));
    }
}

