/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.alignment;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.AlignmentPair;
import org.biojava.bio.alignment.NeedlemanWunsch;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmExample {
    private static final Logger sLogger = LoggerFactory.getLogger(AlgorithmExample.class);
    private final short GAPOPEN = (short)2;
    private final short GAPEXTEND = (short)2;
    private final short MATCH = 1;
    private final short MISMATCH = (short)-1;
    private final short PGAPOPEN = (short)10;
    private final short PGAPEXTEND = (short)5;
    private final short PMATCH = 0;
    private final short PMISMATCH = 0;

    public static void main(String[] args) throws IllegalSymbolException, BioException, NumberFormatException, IOException {
        AlgorithmExample test = new AlgorithmExample();
        test.testrunDNA();
    }

    public void testrunDNA() throws IllegalSymbolException, BioException, NumberFormatException, IOException {
        Sequence query = DNATools.createDNASequence((String)"GCTGA", (String)"query");
        Sequence target = DNATools.createDNASequence((String)"GCCTGA", (String)"target");
        FiniteAlphabet alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"DNA");
        SubstitutionMatrix matrix = new SubstitutionMatrix(alphabet, new File("src/main/resources/blosum62NA.mat"));
        NeedlemanWunsch aligner = new NeedlemanWunsch(1, -1, 2, 2, 2, matrix);
        AlignmentPair pair = aligner.pairwiseAlignment((SymbolList)query, (SymbolList)target);
        System.out.println(pair.formatOutput(100));
        System.out.println("SeqString: " + pair.seqString());
        Iterator i = pair.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
        int correct = pair.getNumIdenticals() + pair.getNumSimilars();
        System.out.println("Correct: " + correct);
        System.out.println("Gap Query: " + pair.getNumGapsInQuery());
        System.out.println("Gap Subject: " + pair.getNumGapsInSubject());
        int gaps = pair.getNumGapsInQuery() + pair.getNumGapsInSubject();
        System.out.println("Gaps: " + gaps);
        int error = query.length() + target.length() - 2 * pair.getNumIdenticals();
        System.out.println("Error: " + error);
    }

    public void testrunAA() {
        try {
            String header1 = ">gb|CP001821.1|:690821-692026 translation elongation factor Tu [Xylanimonas cellulosilytica DSM 15894]";
            String protein1 = "VAKAKFERTKPHVNVGTIGHVDHGKTTLTAAISKTLAEKYPASEGYLANQVVDFDGIDKAPEEKQRGITINISHIEYETPNRHYAHVDAPGHADYIKNMITGAAQMDGAILVVAATDGPMAQTREHVLLARQVGVPYLLVALNKSDMVDDEEILELVEMEVRELLSSQGFDGDDAPVVRVSGLKALEGDPEWQAKVLELMEAVDTNVPEPVRDLDKPFLMPIEDVFTITGRGTVVTGKVERGALNVNSEVEIVGIRNPQKTTVTGIETFHKSMDQAQAGDNTGLLLRGIKREDVERGQVVVKPGSITPHTDFEAQVYILGKDEGGRHNPFYSNYRPQFYFRTTDVTGVISLPEGTEMVMPGDNTEMTVELIQPIAMEEGLGFAIREGGRTVGSGRVTKIIK";
            String header2 = ">dbj|AP006618.1|:c5375075-5373828 putative translation elongation factor TU [Nocardia farcinica IFM 10152]";
            String protein2 = "MTPRTAATAGTNTVQEDKTVAKAKFERTKPHVNIGTIGHVDHGKTTLTAAITKVLADKYPDLNQSFAFDQIDKAPEEKARGITINISHVEYQTEKRHYAHVDAPGHADYIKNMITGAAQMDGAILVVAATDGPMPQTREHVLLARQVGVPYILVALNKADMVDDEEILELVEMEVRELLAAQEFDEEAPVVRVSGLKALEGDPKWVKSVEDLMDAVDESIPDPVRETDKPFLMPIEDVFTITGRGTVVTGRVERGIINVNEEVEITGIRPETTKTTVTGIEMFRKLLDQGQAGDNVGLLIRGIKREDVERGQVVIKPGTTTPHTEFEGQAYILSKDEGGRHTPFFNNYRPQFYFRTTDVTGVVTLPEGTEMVMPGDNTEMSVKLIQPVAMEEGLRFAIREGGRTVGAGRVTKIIK";
            Sequence query = ProteinTools.createProteinSequence((String)protein1, (String)header1.split("\\|")[1]);
            Sequence target = ProteinTools.createProteinSequence((String)protein2, (String)header2.split("\\|")[1]);
            FiniteAlphabet alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName((String)"PROTEIN-TERM");
            SubstitutionMatrix matrix = new SubstitutionMatrix(alphabet, new File("src/main/resources/blosum62.mat"));
            NeedlemanWunsch aligner = new NeedlemanWunsch(0, 0, 10, 10, 5, matrix);
            AlignmentPair pair = aligner.pairwiseAlignment((SymbolList)query, (SymbolList)target);
            System.out.println(pair.formatOutput(100));
            System.out.printf("\n%d\t%d\n", protein1.length(), protein2.length());
        }
        catch (Exception ex) {
            sLogger.error("testrunAA() failed - error aligning sequences!", (Throwable)ex);
        }
    }
}

