/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import edu.mayo.pipes.bioinformatics.HeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinitionHelpers;
import edu.mayo.pipes.bioinformatics.KeyValueHeaderPair;
import edu.mayo.pipes.bioinformatics.VCFParseException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

public class InfoHeader
extends HeaderFieldDefinition {
    public String source;
    public String version;

    public InfoHeader() {
        this.fieldType = "INFO";
        this.requiredFields = Arrays.asList("ID", "Type", "Number", "Description");
        this.source = "";
        this.version = "";
    }

    public void createFromString(String infoHeaderLine) throws VCFParseException, UnsupportedEncodingException {
        this.originalLine = infoHeaderLine;
        this.verifyLine(infoHeaderLine);
        String PREFIX = "##" + this.fieldType + "=<";
        infoHeaderLine = infoHeaderLine.substring(PREFIX.length(), infoHeaderLine.length() - 1);
        Map<String, KeyValueHeaderPair> keyValPairMap = HeaderFieldDefinitionHelpers.getKeyValuePairsFromString(infoHeaderLine);
        this.id = this.getFirstVal(keyValPairMap.get("ID"));
        this.type = HeaderFieldDefinitionHelpers.parseType(this.getFirstVal(keyValPairMap.get("Type")));
        this.number = HeaderFieldDefinitionHelpers.parseNumber(this.getFirstVal(keyValPairMap.get("Number")), this.type);
        this.desc = this.stripQuotesAndUnescape(this.getFirstVal(keyValPairMap.get("Description")), true);
        this.source = this.stripQuotesAndUnescape(this.getFirstVal(keyValPairMap.get("Source")), true);
        this.version = this.stripQuotesAndUnescape(this.getFirstVal(keyValPairMap.get("Version")), true);
    }

    private void verifyLine(String metaHeaderLine) {
        if (!metaHeaderLine.startsWith("##" + this.fieldType + "=<") && !metaHeaderLine.endsWith(">")) {
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  Format should be: ##" + this.fieldType + "=<....>\nExample:  ##INFO=<ID=AF,Number=A,Type=Float,Description=\"Allele Frequency\",Source=\"dbSNP\",Version=\"142\">  ");
        }
        for (String requiredField : this.requiredFields) {
            if (metaHeaderLine.contains("<" + requiredField + "=") || metaHeaderLine.contains("," + requiredField + "=")) continue;
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  These fields are required: " + this.requiredFields.toString());
        }
    }
}

