/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.lookup;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.index.FindIndex;
import edu.mayo.pipes.util.index.H2Connection;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupPipe
extends AbstractPipe<History, History> {
    private IndexUtils mUtils = new IndexUtils();
    private Connection mDbConn;
    protected boolean mIsFirst = true;
    protected ComparableObjectInterface mComparableObject;
    protected int mHistoryPos = -1;
    private File mBgzipFile;
    private String mIndexFile;
    private int mJsonpos = 3;
    private FindIndex mFindIndex;
    private List<History> mResults = null;
    private int drillColumn = -1;
    private static Logger sLogger = LoggerFactory.getLogger(LookupPipe.class.getClass());
    public static final String kBlankJSON = "{}";

    public LookupPipe(String catalogFile, String indexFile) throws SQLException, IOException {
        this(catalogFile, indexFile, -1, false);
    }

    public LookupPipe(String catalogFile, String indexFile, int drillColumn) throws SQLException, IOException {
        this(catalogFile, indexFile, drillColumn, false);
    }

    public LookupPipe(String catalogFile, String indexFile, int drillColumn, boolean isKeyCaseSensitive) throws SQLException, IOException {
        this.mBgzipFile = new File(catalogFile);
        this.mIndexFile = indexFile;
        H2Connection indexLookup = new H2Connection(this.mIndexFile, false);
        this.mDbConn = indexLookup.getConn();
        this.mUtils = new IndexUtils(this.mBgzipFile);
        this.mFindIndex = new FindIndex(this.mDbConn, isKeyCaseSensitive);
        this.drillColumn = drillColumn;
    }

    public List<String> getIDs(List<History> hs, int col) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < hs.size(); ++i) {
            History h = hs.get(i);
            ids.add((String)h.get(col));
        }
        return ids;
    }

    protected void setup(History history) {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            int size = history.size();
            if (this.drillColumn > 0) {
                this.drillColumn = this.drillColumn - size - 1;
            } else if (this.drillColumn == 0) {
                throw new InvalidPipeInputException("Invalid Column input", (Pipe)this);
            }
            if (size == 1) {
                this.drillColumn = -1;
            }
        }
    }

    public List<History> processHistory(History history, int getColumn) throws NoSuchElementException {
        this.setup(history);
        int curColumn = this.drillColumn;
        this.drillColumn = getColumn < 0 ? getColumn : getColumn - history.size();
        List<History> results = this.processHistory(history);
        this.drillColumn = curColumn;
        return results;
    }

    public List<History> processHistory(History history) throws NoSuchElementException {
        ArrayList<History> results = new ArrayList<History>();
        this.setup(history);
        String id = (String)history.get(history.size() + this.drillColumn);
        if (this.validateIdToFind(id)) {
            try {
                LinkedList<Long> posQueue = this.mFindIndex.find(id);
                for (Long next : posQueue) {
                    String json = kBlankJSON;
                    try {
                        String line = this.mUtils.getBgzipLineByPosition(next);
                        if (line.length() > 2) {
                            String[] split = line.split("\t");
                            json = split[this.mJsonpos];
                        }
                    }
                    catch (OutOfMemoryError outOfMemError) {
                        String catalogPath = this.mBgzipFile.getName();
                        String indexPath = this.mIndexFile;
                        try {
                            catalogPath = this.mBgzipFile.getCanonicalPath();
                            indexPath = new File(this.mIndexFile).getCanonicalPath();
                        }
                        catch (Exception e) {
                            sLogger.error(e.getMessage());
                        }
                        String msg = "Out of memory - bior_lookup index is probably out of sync with the catalog.\n  Catalog: " + catalogPath + "\n  Index:   " + indexPath;
                        sLogger.error(msg);
                        System.err.println(msg);
                        throw new NoSuchElementException(msg);
                    }
                    catch (Exception ex) {
                        sLogger.error(ex.getMessage(), (Throwable)ex);
                    }
                    results.add(this.copyAppend(history, json));
                }
            }
            catch (SQLException ex) {
                sLogger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (results.isEmpty()) {
            results.add(this.copyAppend(history, kBlankJSON));
        }
        return results;
    }

    public History processNextStart() throws NoSuchElementException {
        if (this.mResults == null || this.mResults.isEmpty()) {
            this.mResults = this.processHistory((History)this.starts.next());
        }
        return this.mResults.remove(0);
    }

    private boolean validateIdToFind(String idToFind) {
        boolean result = false;
        if (idToFind != null && !idToFind.equals(".") && !idToFind.equals("")) {
            result = true;
        }
        return result;
    }

    protected History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add(result);
        return clone;
    }

    public int getJsonpos() {
        return this.mJsonpos;
    }

    public void setJsonpos(int jsonpos) {
        this.mJsonpos = jsonpos;
    }
}

