/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON;

import com.google.gson.JsonObject;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.DelimVocab;
import edu.mayo.pipes.util.JSONUtil;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delim2JSONPipe
extends AbstractPipe<History, History> {
    private static final Logger sLogger = LoggerFactory.getLogger(Delim2JSONPipe.class);
    private int index = -1;
    private String[] meta = null;
    private boolean keepOriginalColumn = true;
    private String delim = ":";

    public Delim2JSONPipe(int index, boolean keepOriginalColumn, String[] headers, String delim) {
        this.meta = headers;
        this.delim = DelimVocab.toRegEX(delim);
        this.index = index;
        this.keepOriginalColumn = keepOriginalColumn;
    }

    public Delim2JSONPipe(String[] headers, String delim) {
        this.meta = headers;
        this.delim = DelimVocab.toRegEX(delim);
    }

    private int fixIndex(History h) {
        if (this.index > 0) {
            this.index = this.index - h.size() - 1;
            return this.index;
        }
        return this.index;
    }

    protected History processNextStart() throws NoSuchElementException {
        History history = (History)this.starts.next();
        this.fixIndex(history);
        int pos = history.size() + this.index;
        String foo = (String)history.get(pos);
        history.add(this.computeJSON(foo));
        if (!this.keepOriginalColumn) {
            history.remove(history.size() + this.index - 1);
        }
        return history;
    }

    private String computeJSON(String col) {
        if (".".equals(col)) {
            return "{}";
        }
        JsonObject f = new JsonObject();
        String[] split = col.split(this.delim);
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            if (JSONUtil.isInt(s)) {
                f.addProperty(this.meta[i], (Number)JSONUtil.toInt(s));
                continue;
            }
            if (JSONUtil.isDouble(s)) {
                f.addProperty(this.meta[i], (Number)JSONUtil.toDouble(s));
                continue;
            }
            f.addProperty(this.meta[i], s);
        }
        return f.toString().trim();
    }
}

