/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.biojava.utils.io.Seekable;

public class CachingInputStream
extends InputStream
implements Seekable {
    private static final int INIT_CACHE_SIZE = 1024;
    private static final int RESIZE_FACTOR = 3;
    protected byte[] cache;
    protected int ptr;
    protected int validLen;
    protected InputStream in;

    public CachingInputStream(InputStream in) {
        this.in = in;
        this.cache = new byte[1024];
        this.validLen = 0;
        this.ptr = 0;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > Integer.MAX_VALUE || pos < 0L) {
            throw new IllegalArgumentException("Cannot seek to " + pos + ": can only do 0 <= seek < " + Integer.MAX_VALUE);
        }
        int newPtr = (int)pos;
        if (newPtr <= this.validLen) {
            this.ptr = newPtr;
        } else {
            this.skip(newPtr - this.ptr);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.ptr < this.validLen) {
            int out = 0xFF & this.cache[this.ptr];
            ++this.ptr;
            return out;
        }
        int read = this.in.read();
        if (read >= 0) {
            this.expandCache(1);
            this.cache[this.ptr] = (byte)read;
            ++this.ptr;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int start, int len) throws IOException {
        int cachedLen = Math.min(Math.max(this.validLen - this.ptr, 0), len);
        System.arraycopy(this.cache, this.ptr, b, start, cachedLen);
        this.ptr += cachedLen;
        int bytesRead = this.in.read(b, start + cachedLen, len - cachedLen);
        this.expandCache(bytesRead);
        System.arraycopy(b, start + cachedLen, this.cache, this.ptr, bytesRead);
        this.ptr += bytesRead;
        return bytesRead + cachedLen;
    }

    @Override
    public long skip(long num) throws IOException {
        int i;
        if ((long)this.ptr + num > Integer.MAX_VALUE) {
            return 0L;
        }
        int n = (int)num;
        int availCache = Math.min(this.validLen - this.ptr, n);
        this.ptr += availCache;
        this.expandCache(n -= availCache);
        IOException ioEx = null;
        try {
            int count;
            for (i = 0; i < n && (count = this.in.read(this.cache, this.ptr + i, n - i)) >= 0; i += count) {
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            ioEx = e;
        }
        this.validLen -= n - i;
        this.ptr += i;
        if (ioEx != null) {
            throw ioEx;
        }
        return i + availCache;
    }

    protected void expandCache(int additionalBytes) {
        if (this.cache.length < this.validLen + additionalBytes) {
            int newLen;
            for (newLen = this.cache.length; newLen < this.validLen + additionalBytes; newLen *= 3) {
            }
            byte[] newCache = new byte[newLen];
            System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
            this.cache = newCache;
        }
        this.validLen += additionalBytes;
    }
}

