/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.Set;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.PatternListener;
import org.biojava.utils.automata.StateMachineFactory;
import org.biojava.utils.automata.StateMachineInstance;
import org.biojava.utils.automata.StateMachineToolkit;

public class ArrayStateMachineToolkit
implements StateMachineToolkit {
    private FiniteAlphabet alfa;
    private boolean greedy;

    ArrayStateMachineToolkit(FiniteAlphabet alfa, boolean greedy) {
        this.alfa = alfa;
        this.greedy = greedy;
    }

    @Override
    public StateMachineFactory getFactory(String factoryName, FiniteAutomaton fa) throws IllegalAlphabetException {
        if (this.alfa != fa.getAlphabet()) {
            throw new IllegalAlphabetException("The FiniteAutomaton is defined on an Alphabet incompatible with this ArrayStateMachineToolKit.");
        }
        return new ArrayStateMachine(factoryName, fa, this.greedy);
    }

    private static class ArrayStateMachine
    implements StateMachineFactory {
        private static byte ERROR_STATE = (byte)-128;
        private String name;
        private FiniteAlphabet alfa;
        private boolean greedy;
        private PatternListener listener = null;
        private int[] entryPoints;
        private byte[] transitions;

        ArrayStateMachine(String name, FiniteAutomaton fa, boolean greedy) {
            this.name = name;
            this.alfa = fa.getAlphabet();
            int alfaSize = this.alfa.size();
            this.entryPoints = new int[fa.nodeCount()];
            this.transitions = new byte[alfaSize * fa.nodeCount()];
            this.greedy = greedy;
            this.convert(fa);
            fa = null;
        }

        @Override
        public void setListener(PatternListener listener) {
            this.listener = listener;
        }

        private void convert(FiniteAutomaton fa) {
            try {
                int i;
                AlphabetIndex alfaIdx = AlphabetManager.getAlphabetIndex(this.alfa);
                int idx = 0;
                int alfaSize = this.alfa.size();
                for (i = 0; i < this.entryPoints.length; ++i) {
                    this.entryPoints[i] = idx;
                    idx += alfaSize;
                }
                for (i = 0; i < this.transitions.length; ++i) {
                    this.transitions[i] = ERROR_STATE;
                }
                Set transitionSet = fa.getTransitions();
                for (FiniteAutomaton.Transition currTransition : transitionSet) {
                    int symIdx = alfaIdx.indexForSymbol(currTransition.getSymbol());
                    this.transitions[this.entryPoints[Math.abs((int)currTransition.getSource().getID())] + symIdx] = (byte)currTransition.getDest().getID();
                }
            }
            catch (IllegalSymbolException ise) {
                throw new AssertionError((Object)ise);
            }
        }

        StateMachineInstance getInstance(int start) {
            if (this.greedy) {
                return new GreedyInstance(start, start, 0);
            }
            return new Instance(start, start, 0);
        }

        @Override
        public StateMachineInstance startInstance(int symIdx, int start) {
            byte nextState = this.transitions[symIdx];
            if (nextState != ERROR_STATE) {
                if (this.greedy) {
                    return new GreedyInstance(start, start + 1, nextState);
                }
                return new Instance(start, start + 1, nextState);
            }
            return null;
        }

        class GreedyInstance
        implements StateMachineInstance {
            private int statePointer;
            private int start;
            private int end;
            boolean gotTerminationState = false;

            private GreedyInstance(int start, int end, int statePointer) {
                this.start = start;
                this.statePointer = statePointer;
            }

            @Override
            public int getStart() {
                return this.start;
            }

            @Override
            public boolean transit(int symIdx) {
                byte dest = ArrayStateMachine.this.transitions[ArrayStateMachine.this.entryPoints[this.statePointer] + symIdx];
                if (dest == ERROR_STATE) {
                    if (this.gotTerminationState) {
                        ArrayStateMachine.this.listener.notifyHit(ArrayStateMachine.this.name, this.start, this.end, true);
                    }
                    return false;
                }
                ++this.end;
                this.statePointer = Math.abs(dest);
                if (dest < 0) {
                    this.gotTerminationState = true;
                    return false;
                }
                return true;
            }

            public boolean equals(Object o) {
                if (!(o instanceof Instance)) {
                    return false;
                }
                Instance other = (Instance)o;
                if (other.parent() != ArrayStateMachine.this) {
                    return false;
                }
                return this.start == other.getStart();
            }

            @Override
            public StateMachineFactory parent() {
                return ArrayStateMachine.this;
            }
        }

        class Instance
        implements StateMachineInstance {
            private int statePointer = 0;
            private int start;
            private int end;

            private Instance(int start, int end, int statePointer) {
                this.start = start;
                this.end = end;
                this.statePointer = statePointer;
            }

            @Override
            public int getStart() {
                return this.start;
            }

            @Override
            public boolean transit(int symIdx) {
                byte dest = ArrayStateMachine.this.transitions[ArrayStateMachine.this.entryPoints[this.statePointer] + symIdx];
                if (dest == ERROR_STATE) {
                    return false;
                }
                ++this.end;
                this.statePointer = Math.abs(dest);
                if (dest < 0) {
                    ArrayStateMachine.this.listener.notifyHit(ArrayStateMachine.this.name, this.start, this.end, false);
                    return false;
                }
                return true;
            }

            public boolean equals(Object o) {
                if (!(o instanceof Instance)) {
                    return false;
                }
                Instance other = (Instance)o;
                if (other.parent() != ArrayStateMachine.this) {
                    return false;
                }
                return this.start == other.getStart();
            }

            @Override
            public StateMachineFactory parent() {
                return ArrayStateMachine.this;
            }
        }
    }
}

