/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class PolynomialKernel
extends NestedKernel {
    private double order;
    private double a;
    private double c;

    public PolynomialKernel() {
        this(null, 3.0, 1.0, 1.0);
    }

    public PolynomialKernel(SVMKernel nested, double order, double a, double c) {
        super(nested);
        this.order = order;
        this.a = a;
        this.c = c;
    }

    @Override
    public double evaluate(Object a, Object b) {
        return Math.pow(this.getMultiplier() * this.getNestedKernel().evaluate(a, b) + this.getConstant(), this.getOrder());
    }

    public double getOrder() {
        return this.order;
    }

    public void setOrder(double o) {
        this.order = o;
    }

    public double getConstant() {
        return this.c;
    }

    public void setConstant(double c) {
        this.c = c;
    }

    public double getMultiplier() {
        return this.a;
    }

    public void setMultiplier(double m) {
        this.a = m;
    }

    public String toString() {
        return "Polynomial kernel K(x, y | k) = (" + this.getMultiplier() + " * k(x, y) + " + this.c + ")^" + this.order + ". k = " + this.getNestedKernel().toString();
    }
}

