/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import javax.naming.spi.InitialContextFactory;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.naming.ObdaContext;
import org.biojava.naming.ObdaUriParser;
import org.biojava.utils.ClassTools;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ObdaInitialContextFactory
implements InitialContextFactory {
    private static final String CORE = "obda/naming/core.xml";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        try {
            InputSource iSource = new InputSource(ClassTools.getClassLoader(ObdaInitialContextFactory.class).getResourceAsStream(CORE));
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            XMLReader reader = spf.newSAXParser().getXMLReader();
            ObdaHandler handler = new ObdaHandler(environment);
            reader.setContentHandler(handler);
            reader.parse(iSource);
            return handler.getRoot();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private class ObdaHandler
    extends DefaultHandler {
        Hashtable env;
        ObdaContext root;
        ObdaContext current;
        StringBuffer description = null;

        ObdaHandler(Hashtable env) {
            this.env = env;
        }

        public ObdaContext getRoot() {
            return this.root;
        }

        @Override
        public void startDocument() throws SAXException {
            this.root = new ObdaContext(null, null, new Hashtable(), this.env, new BasicAttributes());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!qName.equals("directory")) {
                if (qName.equals("urn")) {
                    try {
                        Name name = ObdaUriParser.getInstance().parse(attributes.getValue("name"));
                        ObdaContext ctxt = this.root;
                        for (int i = 0; i < name.size(); ++i) {
                            ctxt = this.resolve(ctxt, name.get(i));
                        }
                        this.current = ctxt;
                    }
                    catch (NamingException e) {
                        throw new SAXException(e);
                    }
                } else if (qName.equals("description")) {
                    this.description = new StringBuffer();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description") && this.description != null) {
                this.current.getAttrs().put("description", this.description.toString());
                this.description = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.description != null) {
                this.description.append(ch, start, length);
            }
        }

        private ObdaContext resolve(ObdaContext parent, String name) {
            Hashtable bindings = parent.getBindings();
            ObdaContext child = (ObdaContext)bindings.get(name);
            if (child == null) {
                child = new ObdaContext(parent, name, new Hashtable(), new Hashtable(), new BasicAttributes());
                bindings.put(name, child);
            }
            return child;
        }
    }
}

