/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.symbol.AbstractReversibleTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SimpleReversibleTranslationTable
extends AbstractReversibleTranslationTable
implements Serializable {
    private final Map transMap;
    private final Map revMap;
    private final FiniteAlphabet source;
    private final Alphabet target;

    @Override
    public Alphabet getSourceAlphabet() {
        return this.source;
    }

    @Override
    public Alphabet getTargetAlphabet() {
        return this.target;
    }

    @Override
    protected Symbol doTranslate(Symbol sym) {
        return (Symbol)this.transMap.get(sym);
    }

    @Override
    protected Symbol doUntranslate(Symbol sym) {
        return (Symbol)this.revMap.get(sym);
    }

    public void setTranslation(AtomicSymbol from, AtomicSymbol to) throws IllegalSymbolException {
        this.source.validate(from);
        this.target.validate(to);
        this.transMap.put(from, to);
        this.revMap.put(to, from);
    }

    public SimpleReversibleTranslationTable(FiniteAlphabet source, FiniteAlphabet target) throws IllegalAlphabetException {
        if (source.size() != target.size()) {
            throw new IllegalAlphabetException("Couldn't create translation table as the alphabets were different sizes: " + source.size() + ":" + source.getName() + target.size() + ":" + target.getName());
        }
        this.source = source;
        this.target = target;
        this.transMap = new HashMap();
        this.revMap = new HashMap();
    }
}

