/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class ChunkedSymbolList
extends AbstractSymbolList
implements Serializable {
    private SymbolList[] chunks;
    private final int chunkSize;
    private final Alphabet alpha;
    private int length;
    private transient int currentMin = Integer.MAX_VALUE;
    private transient int currentMax = Integer.MIN_VALUE;
    private transient SymbolList currentChunk = null;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.currentMin = Integer.MAX_VALUE;
        this.currentMax = Integer.MIN_VALUE;
        this.currentChunk = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public ChunkedSymbolList(SymbolList[] chunks, int chunkSize, int length, Alphabet alpha) {
        this.chunks = chunks;
        this.chunkSize = chunkSize;
        this.length = length;
        this.alpha = alpha;
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alpha;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public synchronized Symbol symbolAt(int pos) {
        int offset;
        if (--pos < this.currentMin || pos > this.currentMax) {
            int chnk = pos / this.chunkSize;
            offset = pos % this.chunkSize;
            this.currentMin = pos - offset;
            this.currentMax = this.currentMin + this.chunkSize - 1;
            this.currentChunk = this.chunks[chnk];
        } else {
            offset = pos - this.currentMin;
        }
        return this.currentChunk.symbolAt(offset + 1);
    }

    @Override
    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        int ato = end - 1;
        int afrom = start - 1;
        int cfrom = afrom / this.chunkSize;
        if (ato / this.chunkSize == cfrom) {
            return this.chunks[cfrom].subList(afrom % this.chunkSize + 1, ato % this.chunkSize + 1);
        }
        return super.subList(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void edit(Edit edit) throws IllegalAlphabetException, ChangeVetoException {
        ChangeSupport cs;
        if (edit.pos + edit.length > this.length + 1 || edit.pos <= 0 || edit.length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (edit.replacement.getAlphabet() != this.getAlphabet() && edit.replacement != SymbolList.EMPTY_LIST) {
            throw new IllegalAlphabetException();
        }
        ChangeEvent cevt = new ChangeEvent(this, SymbolList.EDIT, edit);
        ChangeSupport changeSupport = cs = this.getChangeSupport(SymbolList.EDIT);
        synchronized (changeSupport) {
            int chunkNum;
            int i;
            cs.firePreChangeEvent(cevt);
            int posRightFragInSourceArray = edit.pos + edit.length - 1;
            int rightFragLength = this.length - posRightFragInSourceArray;
            int posRightFragInDestArray = posRightFragInSourceArray + edit.replacement.length() - edit.length;
            int posReplaceFragInDestArray = edit.pos - 1;
            int replaceFragLength = edit.replacement.length();
            int newLength = this.length + replaceFragLength - edit.length;
            Symbol[] dest = new Symbol[newLength];
            int leftFragLength = edit.pos - 1;
            for (i = 0; i < this.chunks.length; ++i) {
                SymbolList chunk = this.chunks[i];
                Symbol[] chunkSymbol = ((SimpleSymbolList)chunk).getSymbolArray();
                int desStart = i * this.chunkSize;
                int desEnd = i * this.chunkSize + chunk.length();
                if (desEnd >= leftFragLength) {
                    desEnd = leftFragLength;
                    System.arraycopy(chunkSymbol, 0, dest, desStart, desEnd - desStart);
                    break;
                }
                System.arraycopy(chunkSymbol, 0, dest, desStart, desEnd - desStart);
            }
            if (rightFragLength > 0) {
                chunkNum = posRightFragInSourceArray / this.chunkSize;
                int chunkStart = posRightFragInSourceArray % this.chunkSize;
                int chunkCopied = 0;
                for (int i2 = chunkNum; i2 < this.chunks.length; ++i2) {
                    SymbolList chunk = this.chunks[i2];
                    Symbol[] chunkSymbol = ((SimpleSymbolList)chunk).getSymbolArray();
                    int desStart = posRightFragInDestArray + chunkCopied;
                    int desLength = chunk.length() - chunkStart;
                    int left = rightFragLength - chunkCopied;
                    if (left == 0) break;
                    if (desLength > left) {
                        desLength = left;
                    }
                    System.arraycopy(chunkSymbol, chunkStart, dest, desStart, desLength);
                    if (chunkStart != 0) {
                        chunkStart = 0;
                    }
                    chunkCopied += desLength;
                }
            }
            for (i = 1; i <= replaceFragLength; ++i) {
                dest[posReplaceFragInDestArray + i - 1] = edit.replacement.symbolAt(i);
            }
            chunkNum = newLength / this.chunkSize;
            int chunkLeft = newLength % this.chunkSize;
            int chunkReused = (edit.pos - 1) / this.chunkSize;
            if (chunkLeft > 0) {
                ++chunkNum;
            }
            SymbolList[] symListArray = new SymbolList[chunkNum];
            for (int i3 = 0; i3 < chunkNum - 1; ++i3) {
                if (i3 < chunkReused) {
                    symListArray[i3] = this.chunks[i3];
                    continue;
                }
                Symbol[] chunk = new Symbol[this.chunkSize];
                System.arraycopy(dest, i3 * this.chunkSize, chunk, 0, this.chunkSize);
                symListArray[i3] = new SimpleSymbolList(chunk, this.chunkSize, this.getAlphabet());
            }
            if (chunkLeft > 0) {
                Symbol[] chunk = new Symbol[chunkLeft];
                System.arraycopy(dest, (chunkNum - 1) * this.chunkSize, chunk, 0, chunkLeft);
                symListArray[chunkNum - 1] = new SimpleSymbolList(chunk, chunkLeft, this.getAlphabet());
            } else {
                Symbol[] chunk = new Symbol[this.chunkSize];
                System.arraycopy(dest, (chunkNum - 1) * this.chunkSize, chunk, 0, this.chunkSize);
                symListArray[chunkNum - 1] = new SimpleSymbolList(chunk, this.chunkSize, this.getAlphabet());
            }
            this.chunks = symListArray;
            this.length = newLength;
            this.currentMin = Integer.MAX_VALUE;
            this.currentMax = Integer.MIN_VALUE;
            this.currentChunk = null;
            cs.firePostChangeEvent(cevt);
        }
    }
}

