/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.agave.AGAVEAltIdsPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEBioSeqCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVECallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEClassificationHandler;
import org.biojava.bio.seq.io.agave.AGAVEContigCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEDbIdPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEDescPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEKeywordPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEMapLocationPropHandler;
import org.biojava.bio.seq.io.agave.AGAVENotePropHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqMapHandler;
import org.biojava.bio.seq.io.agave.AGAVESeqPropHandler;
import org.biojava.bio.seq.io.agave.AGAVEXrefsPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.SequenceHandler;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEBioSeqHandler
extends StAXFeatureHandler
implements AGAVEBioSeqCallbackItf,
SequenceHandler {
    public static final StAXHandlerFactory AGAVE_BIO_SEQ_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEBioSeqHandler(staxenv);
        }
    };
    private SymbolList dna;
    protected Sequence sequence;

    AGAVEBioSeqHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("bio_sequence", true);
        super.addHandler(new ElementRecognizer.ByLocalName("db_id"), AGAVEDbIdPropHandler.AGAVE_DBID_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("note"), AGAVENotePropHandler.AGAVE_NOTE_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("description"), AGAVEDescPropHandler.AGAVE_DESC_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("keyword"), AGAVEKeywordPropHandler.AGAVE_KEYWORD_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("sequence"), AGAVESeqPropHandler.AGAVE_SEQ_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("alt_ids"), AGAVEAltIdsPropHandler.AGAVE_ALT_IDS_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("xrefs"), AGAVEXrefsPropHandler.AGAVE_XREFS_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("sequence_map"), AGAVESeqMapHandler.AGAVE_SEQ_MAP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("map_location"), AGAVEMapLocationPropHandler.AGAVE_MAP_LOCATION_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("classification"), AGAVEClassificationHandler.AGAVE_CLASSIFICATION_HANDLER_FACTORY);
    }

    @Override
    public void reportStrand(StrandedFeature.Strand strand) {
        ((StrandedFeature.Template)this.featureTemplate).strand = strand;
    }

    @Override
    public void reportFeature(Location loc) {
        ((StrandedFeature.Template)this.featureTemplate).location = loc;
    }

    @Override
    public void reportDna(String dna_seq) {
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dna_seq.length(); ++i) {
                char c = dna_seq.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t') continue;
                sb.append(c);
            }
            this.dna = DNATools.createDNA(sb.substring(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.featureListener.startSequence();
            boolean forFeature = false;
            this.setProperty("element_id", attrs.getValue("element_id"), forFeature);
            this.setProperty("sequence_id", attrs.getValue("sequence_id"), forFeature);
            this.setProperty("seq_length", attrs.getValue("seq_length"), forFeature);
            this.setProperty("molecule_type", attrs.getValue("molecule_type"), forFeature);
            this.setProperty("organism_name", attrs.getValue("organism_name"), forFeature);
            this.setProperty("taxon_id", attrs.getValue("taxon_id"), forFeature);
            this.setProperty("clone_id", attrs.getValue("clone_id"), forFeature);
            this.setProperty("clone_library", attrs.getValue("clone_library"), forFeature);
            this.setProperty("chromosome", attrs.getValue("chromosome"), forFeature);
            this.setProperty("map_position", attrs.getValue("map_position"), forFeature);
            this.setProperty("ec_number", attrs.getValue("ec_number"), forFeature);
            this.setProperty("create_date", attrs.getValue("create_date"), forFeature);
            this.setProperty("update_date", attrs.getValue("update_date"), forFeature);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        try {
            if (this.dna == null) {
                throw new SAXException("dna sequence need offered for creating sequence object");
            }
            this.sequence = new SimpleSequence(this.dna, " ", "simple_sequence ", this.annot);
            if (this.featureTemplate == null) {
                throw new SAXException("feature template is null ");
            }
            this.addFeatureToSequence(this.sequence);
            this.appendToTop(this.sequence, this.staxenv);
            this.featureListener.endSequence();
        }
        catch (BioException be) {
            throw new SAXException("bio exception");
        }
        catch (ChangeVetoException cve) {
            throw new SAXException("change veto exception");
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void appendToTop(Sequence sequence, StAXFeatureHandler staxenv) {
        if (staxenv instanceof AGAVEContigCallbackItf) {
            ((AGAVEContigCallbackItf)((Object)staxenv)).reportSequence(sequence);
            return;
        }
        if (staxenv instanceof AGAVECallbackItf) {
            ((AGAVECallbackItf)((Object)staxenv)).reportSequence(sequence);
            return;
        }
        this.appendToTop(sequence, staxenv.staxenv);
    }
}

