/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.seq.io.WordTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

public class NameTokenization
extends WordTokenization {
    private transient Map nameToSymbol = null;
    private boolean caseSensitive;

    public NameTokenization(FiniteAlphabet fab, boolean caseSensitive) {
        super(fab);
        fab.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
        this.caseSensitive = caseSensitive;
    }

    public NameTokenization(FiniteAlphabet fab) {
        this(fab, false);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.getAlphabet().removeChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
    }

    protected Map getNameToSymbol() {
        if (this.nameToSymbol == null) {
            this.nameToSymbol = new HashMap();
            Iterator<Symbol> i = ((FiniteAlphabet)this.getAlphabet()).iterator();
            while (i.hasNext()) {
                Symbol sym = i.next();
                if (this.caseSensitive) {
                    this.nameToSymbol.put(sym.getName(), sym);
                    continue;
                }
                this.nameToSymbol.put(sym.getName().toLowerCase(), sym);
            }
            this.nameToSymbol.put("gap", this.getAlphabet().getGapSymbol());
        }
        return this.nameToSymbol;
    }

    @Override
    public Symbol parseToken(String token) throws IllegalSymbolException {
        Symbol sym = this.caseSensitive ? (Symbol)this.getNameToSymbol().get(token) : (Symbol)this.getNameToSymbol().get(token.toLowerCase());
        if (sym == null) {
            char c = token.charAt(0);
            if (c == '[') {
                if (token.charAt(token.length() - 1) != ']') {
                    throw new IllegalSymbolException("Mismatched parentheses: " + token);
                }
                Symbol[] syms = this.parseString(token.substring(1, token.length() - 1));
                HashSet<Symbol> ambigSet = new HashSet<Symbol>();
                for (int i = 0; i < syms.length; ++i) {
                    ambigSet.add(syms[i]);
                }
                return this.getAlphabet().getAmbiguity(ambigSet);
            }
            throw new IllegalSymbolException("Token `" + token + "' does not appear as a named symbol in alphabet `" + this.getAlphabet().getName() + "'");
        }
        return sym;
    }

    @Override
    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        return s.getName();
    }
}

