/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class GenbankFileFormer
extends AbstractGenEmblFileFormer
implements SeqFileFormer {
    private PrintStream stream;
    private StringBuffer sq = new StringBuffer();
    private StringBuffer qb = new StringBuffer();
    private StringBuffer ub = new StringBuffer();
    private StringBuffer idb = null;
    private StringBuffer acb = null;
    private StringBuffer deb = null;
    private StringBuffer svb = null;
    private StringBuffer kwb = null;
    private StringBuffer osb = null;
    private StringBuffer ocb = null;
    private StringBuffer ccb = null;
    private Object rfb = null;
    private StringBuffer ftb = new StringBuffer();
    private StringBuffer typeb = new StringBuffer();
    private StringBuffer strb = new StringBuffer();
    private StringBuffer sizeb = new StringBuffer();
    private StringBuffer circb = new StringBuffer();
    private StringBuffer mdatb = new StringBuffer();
    private StringBuffer divb = new StringBuffer();
    private SymbolTokenization dnaTokenization;
    private boolean vecNTISupport = false;

    protected GenbankFileFormer() {
        this(System.out);
    }

    protected GenbankFileFormer(PrintStream stream) {
        try {
            this.dnaTokenization = DNATools.getDNA().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Couldn't initialize tokenizer for the DNA alphabet", ex);
        }
        this.stream = stream;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.stream;
    }

    @Override
    public void setPrintStream(PrintStream stream) {
        this.stream = stream;
    }

    @Override
    public void setName(String id) throws ParseException {
        this.idb = new StringBuffer("LOCUS       " + id);
    }

    @Override
    public void startSequence() throws ParseException {
    }

    @Override
    public void endSequence() throws ParseException {
    }

    @Override
    public void setURI(String uri) throws ParseException {
    }

    @Override
    public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
        try {
            int aCount = 0;
            int cCount = 0;
            int gCount = 0;
            int tCount = 0;
            int oCount = 0;
            int end = start + length - 1;
            block8: for (int i = start; i <= end; ++i) {
                char c = this.dnaTokenization.tokenizeSymbol(syms[i]).charAt(0);
                switch (c) {
                    case 'A': 
                    case 'a': {
                        ++aCount;
                        continue block8;
                    }
                    case 'C': 
                    case 'c': {
                        ++cCount;
                        continue block8;
                    }
                    case 'G': 
                    case 'g': {
                        ++gCount;
                        continue block8;
                    }
                    case 'T': 
                    case 't': {
                        ++tCount;
                        continue block8;
                    }
                    default: {
                        ++oCount;
                    }
                }
            }
            this.locusLineCreator(length);
            if (this.idb != null) {
                this.stream.println(this.idb);
            }
            if (this.acb != null) {
                this.stream.println(this.acb);
            }
            if (this.svb != null) {
                this.stream.println(this.svb);
            }
            if (this.deb != null) {
                this.stream.println(this.deb);
            }
            if (this.kwb != null) {
                this.stream.println(this.kwb);
            }
            if (this.osb != null) {
                this.stream.println(this.osb);
            }
            if (this.ocb != null) {
                this.stream.println(this.ocb);
            }
            if (this.ccb != null) {
                this.stream.println(this.ccb);
            }
            if (this.rfb != null) {
                if (this.rfb instanceof List) {
                    Iterator i = ((List)this.rfb).iterator();
                    while (i.hasNext()) {
                        this.stream.println((StringBuffer)i.next());
                    }
                } else {
                    this.stream.println(this.rfb);
                }
            }
            if (this.ftb.length() != 0) {
                this.ftb.insert(0, "FEATURES             Location/Qualifiers" + this.nl);
                this.stream.print(this.ftb);
            }
            this.sq.setLength(0);
            this.sq.append("BASE COUNT    ");
            this.sq.append(aCount + " a   ");
            this.sq.append(cCount + " c   ");
            this.sq.append(gCount + " g   ");
            this.sq.append(tCount + " t    ");
            this.sq.append(oCount + " others");
            this.sq.append(this.nl);
            this.sq.append("ORIGIN");
            this.stream.println(this.sq);
            int fullLine = length / 60;
            int partLine = length % 60;
            int lineCount = fullLine;
            if (partLine > 0) {
                ++lineCount;
            }
            int[] lineLens = new int[lineCount];
            Arrays.fill(lineLens, 60);
            if (partLine > 0) {
                lineLens[lineCount - 1] = partLine;
            }
            char[] emptyLine = new char[80];
            for (int i = 0; i < lineLens.length; ++i) {
                this.sq.setLength(0);
                this.ub.setLength(0);
                int len = lineLens[i];
                Arrays.fill(emptyLine, ' ');
                this.sq.append(emptyLine);
                Symbol[] sa = new Symbol[len];
                System.arraycopy(syms, start + i * 60, sa, 0, len);
                String blocks = this.formatTokenBlock(this.ub, sa, 10, this.dnaTokenization).toString();
                this.sq.replace(10, blocks.length() + 10, blocks);
                String count = Integer.toString(i * 60 + 1);
                this.sq.replace(9 - count.length(), 9, count);
                this.stream.println(this.sq);
            }
            this.stream.println("//");
        }
        catch (IllegalSymbolException ex) {
            throw new IllegalAlphabetException(ex, "DNA not tokenizing");
        }
    }

    @Override
    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if (key.equals("LOCUS")) {
            this.idb.setLength(0);
            this.idb.append("LOCUS       " + (String)value);
        } else if (key.equals("TYPE")) {
            this.typeb.append(value);
        } else if (key.equals("DIVISION")) {
            this.divb.append(value);
        } else if (key.equals("CIRCULAR")) {
            this.circb.append(value);
        } else if (key.equals("DT") || key.equals("MDAT")) {
            if (value instanceof ArrayList) {
                this.mdatb.append(((ArrayList)value).get(0));
            } else {
                this.mdatb.append(value);
            }
        } else if (key.equals("DE") || key.equals("DEFINITION")) {
            this.deb = new StringBuffer(this.sequenceBufferCreator("DEFINITION ", value));
        } else if (key.equals("SV") || key.equals("VERSION")) {
            if (this.svb != null) {
                this.svb.insert(11, (String)value);
            } else {
                this.svb = new StringBuffer("VERSION     " + (String)value);
            }
        } else if (key.equals("GI")) {
            if (this.svb != null) {
                this.svb.append("  GI:" + (String)value);
            } else {
                this.svb = new StringBuffer("VERSION       GI:" + (String)value);
            }
        } else if (key.equals("KW") || key.equals("KEYWORDS")) {
            this.kwb = new StringBuffer(this.sequenceBufferCreator("KEYWORDS   ", value));
        } else if (key.equals("OS") || key.equals("SOURCE")) {
            this.osb = new StringBuffer(this.sequenceBufferCreator("SOURCE     ", value));
        } else if (key.equals("OC") || key.equals("ORGANISM")) {
            this.ocb = new StringBuffer(this.sequenceBufferCreator("  ORGANISM ", value));
        } else if (key.equals("CC") || key.equals("COMMENT")) {
            this.ccb = new StringBuffer(this.sequenceBufferCreator("COMMENT    ", value));
        } else if (key.equals("genbank_accessions")) {
            this.ub.setLength(0);
            this.ub.append("ACCESSION   ");
            if (value instanceof List) {
                Iterator ai = ((List)value).iterator();
                while (ai.hasNext()) {
                    this.ub.append((String)ai.next());
                }
            } else {
                this.ub.append(value);
            }
            this.acb = new StringBuffer(this.ub.substring(0));
        } else if (key.equals("REFERENCE")) {
            if (value instanceof List) {
                ArrayList<StringBuffer> rfbs = new ArrayList<StringBuffer>();
                List refs = (List)value;
                for (String v : refs) {
                    StringBuffer rfb1 = new StringBuffer(this.sequenceBufferCreator("REFERENCE  ", v));
                    rfbs.add(rfb1);
                }
                this.rfb = rfbs;
            } else {
                this.rfb = new StringBuffer(this.sequenceBufferCreator("REFERENCE  ", value));
            }
        } else if (key.equals("AUTHORS")) {
            if (value instanceof List) {
                List rfbs = (List)this.rfb;
                List refs = (List)value;
                Iterator i = refs.iterator();
                Iterator j = rfbs.iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    StringBuffer rfb1 = (StringBuffer)j.next();
                    rfb1.append("\n" + this.sequenceBufferCreator("  AUTHORS  ", v));
                }
            } else if (this.rfb instanceof List) {
                ((StringBuffer)((List)this.rfb).get(0)).append("\n" + this.sequenceBufferCreator("  AUTHORS  ", value));
            } else {
                ((StringBuffer)this.rfb).append("\n" + this.sequenceBufferCreator("  AUTHORS  ", value));
            }
        } else if (key.equals("TITLE")) {
            if (value instanceof List) {
                List rfbs = (List)this.rfb;
                List refs = (List)value;
                Iterator i = refs.iterator();
                Iterator j = rfbs.iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    StringBuffer rfb1 = (StringBuffer)j.next();
                    rfb1.append("\n" + this.sequenceBufferCreator("  TITLE    ", v));
                }
            } else if (this.rfb instanceof List) {
                ((StringBuffer)((List)this.rfb).get(0)).append("\n" + this.sequenceBufferCreator("  TITLE    ", value));
            } else {
                ((StringBuffer)this.rfb).append("\n" + this.sequenceBufferCreator("  TITLE    ", value));
            }
        } else if (key.equals("JOURNAL")) {
            if (value instanceof List) {
                List rfbs = (List)this.rfb;
                List refs = (List)value;
                Iterator i = refs.iterator();
                Iterator j = rfbs.iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    StringBuffer rfb1 = (StringBuffer)j.next();
                    rfb1.append("\n" + this.sequenceBufferCreator("  JOURNAL  ", v));
                }
            } else if (this.rfb instanceof List) {
                ((StringBuffer)((List)this.rfb).get(0)).append("\n" + this.sequenceBufferCreator("  JOURNAL  ", value));
            } else {
                ((StringBuffer)this.rfb).append("\n" + this.sequenceBufferCreator("  JOURNAL  ", value));
            }
        } else if (key.equals("PUBMED")) {
            if (value instanceof List) {
                List rfbs = (List)this.rfb;
                List refs = (List)value;
                Iterator i = refs.iterator();
                Iterator j = rfbs.iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    StringBuffer rfb1 = (StringBuffer)j.next();
                    rfb1.append("\n" + this.sequenceBufferCreator("  PUBMED   ", v));
                }
            } else if (this.rfb instanceof List) {
                ((StringBuffer)((List)this.rfb).get(0)).append("\n" + this.sequenceBufferCreator("  PUBMED   ", value));
            } else {
                ((StringBuffer)this.rfb).append("\n" + this.sequenceBufferCreator("  PUBMED   ", value));
            }
        } else if (key.equals("MEDLINE")) {
            if (value instanceof List) {
                List rfbs = (List)this.rfb;
                List refs = (List)value;
                Iterator i = refs.iterator();
                Iterator j = rfbs.iterator();
                while (i.hasNext()) {
                    String v = (String)i.next();
                    StringBuffer rfb1 = (StringBuffer)j.next();
                    rfb1.append("\n" + this.sequenceBufferCreator("  MEDLINE  ", v));
                }
            } else if (this.rfb instanceof List) {
                ((StringBuffer)((List)this.rfb).get(0)).append("\n" + this.sequenceBufferCreator("  MEDLINE  ", value));
            } else {
                ((StringBuffer)this.rfb).append("\n" + this.sequenceBufferCreator("  MEDLINE  ", value));
            }
        }
    }

    @Override
    public void startFeature(Feature.Template templ) throws ParseException {
        String leader = "                     ";
        int strand = 0;
        if (templ instanceof StrandedFeature.Template) {
            strand = ((StrandedFeature.Template)templ).strand.getValue();
        }
        this.ub.setLength(0);
        this.ub.append(leader);
        StringBuffer lb = this.formatLocationBlock(this.ub, templ.location, strand, leader, 80);
        lb.replace(5, 5 + templ.type.length(), templ.type);
        this.ftb.append(lb + this.nl);
    }

    @Override
    public void endFeature() throws ParseException {
    }

    @Override
    public void addFeatureProperty(Object key, Object value) throws ParseException {
        String leader = "                     ";
        if (key.equals("internal_data")) {
            return;
        }
        if (Collection.class.isInstance(value)) {
            Iterator vi = ((Collection)value).iterator();
            while (vi.hasNext()) {
                this.qb.setLength(0);
                this.ub.setLength(0);
                StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, vi.next()).substring(0), leader, 80);
                this.ftb.append(fb + this.nl);
            }
        } else {
            this.qb.setLength(0);
            this.ub.setLength(0);
            StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, value).substring(0), leader, 80);
            this.ftb.append(fb + this.nl);
        }
    }

    public void setVectorNTISupport(boolean b) {
        this.vecNTISupport = b;
    }

    public boolean getVectorNTISupport() {
        return this.vecNTISupport;
    }

    private String sequenceBufferCreator(Object key, Object value) {
        StringBuffer temp = new StringBuffer();
        if (value == null) {
            temp.append(key.toString());
        } else if (value instanceof ArrayList) {
            Iterator iter = ((ArrayList)value).iterator();
            temp.append(key.toString() + " " + iter.next());
            while (iter.hasNext()) {
                if (this.vecNTISupport) {
                    temp.append(this.nl + key.toString() + "            " + iter.next());
                    continue;
                }
                temp.append(this.nl + "            " + iter.next());
            }
        } else {
            StringTokenizer valueToke = new StringTokenizer((String)value, " ");
            int fullline = 80;
            int length = 0;
            temp.append((String)key);
            if (valueToke.hasMoreTokens()) {
                String token = valueToke.nextToken();
                while (true) {
                    length = temp.length() % (fullline + 1) + token.length() + 1;
                    if (temp.length() % (fullline + 1) == 0) {
                        length = 81 + token.length();
                    }
                    while (length <= fullline && valueToke.hasMoreTokens()) {
                        temp.append(" " + token);
                        token = valueToke.nextToken();
                        length = temp.length() % (fullline + 1) + token.length() + 1;
                        if (temp.length() % (fullline + 1) != 0) continue;
                        length = 81 + token.length();
                    }
                    if (!valueToke.hasMoreTokens()) break;
                    for (int i = length - token.length(); i < fullline; ++i) {
                        temp.append(" ");
                    }
                    temp.append(this.nl + "           ");
                }
                if (length <= fullline) {
                    temp.append(" " + token);
                } else {
                    temp.append(this.nl);
                    temp.append("            " + token);
                }
            } else {
                temp.append(" ");
            }
        }
        return temp.substring(0);
    }

    private StringBuffer fixLength(StringBuffer temp, int length) {
        while (temp.length() < length) {
            temp.append(" ");
        }
        return temp;
    }

    private void locusLineCreator(int size) {
        this.idb = this.fixLength(this.idb, 30);
        this.typeb = this.fixLength(this.typeb, 8);
        this.sizeb.insert(0, size);
        while (this.sizeb.length() < 12) {
            this.sizeb.insert(0, " ");
        }
        this.sizeb.append(" bp ");
        if (this.strb.length() > 0) {
            this.strb.append("-");
        }
        this.strb = this.fixLength(this.strb, 3);
        this.circb = this.fixLength(this.circb, 9);
        this.mdatb = this.fixLength(this.mdatb, 11);
        this.divb = this.fixLength(this.divb, 4);
        this.idb.insert(29, this.sizeb);
        this.idb.insert(44, this.strb);
        this.idb.insert(47, this.typeb);
        this.idb.insert(55, this.circb);
        this.idb.insert(64, this.divb);
        this.idb.insert(68, this.mdatb);
        this.idb.setLength(79);
    }
}

