/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleSequence
extends AbstractChangeable
implements Sequence,
RealizingFeatureHolder,
Serializable {
    private static final long serialVersionUID = -8681680737943980721L;
    private Annotation annotation;
    private transient ChangeListener featureForwarder;
    private SimpleFeatureHolder featureHolder;
    private transient FeatureRealizer featureRealizer;
    private String name;
    private SymbolList symList;
    private String urn;

    public SimpleSequence(SymbolList sym, String urn, String name, Annotation annotation) {
        this.symList = sym;
        this.setURN(urn);
        this.setName(name);
        this.annotation = annotation;
        this.featureRealizer = FeatureImpl.DEFAULT;
    }

    public SimpleSequence(SymbolList sym, String urn, String name, Annotation annotation, FeatureRealizer realizer) {
        this.symList = sym;
        this.setURN(urn);
        this.setName(name);
        this.annotation = annotation;
        this.featureRealizer = realizer;
    }

    @Override
    public boolean containsFeature(Feature f) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().containsFeature(f);
        }
        return false;
    }

    @Override
    public int countFeatures() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().countFeatures();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        SimpleFeatureHolder fh;
        Feature f = this.realizeFeature(this, template);
        SimpleFeatureHolder simpleFeatureHolder = fh = this.getFeatureHolder();
        synchronized (simpleFeatureHolder) {
            fh.addFeature(f);
        }
        return f;
    }

    public Feature createFeature(FeatureHolder fh, Feature.Template template) throws BioException, ChangeVetoException {
        return fh.createFeature(template);
    }

    @Override
    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit the underlying SymbolList");
    }

    protected boolean featureHolderAllocated() {
        return this.featureHolder != null;
    }

    @Override
    public Iterator<Feature> features() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().features();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public FeatureHolder filter(FeatureFilter filter) {
        return this.getFeatureHolder().filter(filter);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().filter(ff, recurse);
        }
        return FeatureHolder.EMPTY_FEATURE_HOLDER;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.symList.getAlphabet();
    }

    @Override
    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport changeSupport = super.getChangeSupport(ct);
        if (this.featureForwarder == null && this.featureHolder != null) {
            this.featureForwarder = new FeatureForwarder();
            this.featureHolder.addChangeListener(this.featureForwarder, ChangeType.UNKNOWN);
        }
        return changeSupport;
    }

    protected SimpleFeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = new SimpleFeatureHolder(FeatureFilter.top_level);
        }
        return this.featureHolder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FeatureFilter getSchema() {
        return this.getFeatureHolder().getSchema();
    }

    @Override
    public String getURN() {
        return this.urn;
    }

    public Iterator iterator() {
        return this.symList.iterator();
    }

    @Override
    public int length() {
        return this.symList.length();
    }

    @Override
    public Feature realizeFeature(FeatureHolder parent, Feature.Template template) throws BioException {
        return this.featureRealizer.realizeFeature(this, parent, template);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatureHolder().removeFeature(f);
    }

    @Override
    public String seqString() {
        return this.symList.seqString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURN(String urn) {
        this.urn = urn;
    }

    @Override
    public SymbolList subList(int start, int end) {
        return this.symList.subList(start, end);
    }

    @Override
    public String subStr(int start, int end) {
        return this.symList.subStr(start, end);
    }

    @Override
    public Symbol symbolAt(int index) {
        return this.symList.symbolAt(index);
    }

    public List toList() {
        return this.symList.toList();
    }

    public String toString() {
        return super.toString() + " name: " + this.getName();
    }

    private class FeatureForwarder
    implements ChangeListener {
        private FeatureForwarder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postChange(ChangeEvent cev) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = SimpleSequence.this.getChangeSupport(cev.getType());
            synchronized (changeSupport) {
                cs.firePostChangeEvent(cev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = SimpleSequence.this.getChangeSupport(cev.getType());
            synchronized (changeSupport) {
                cs.firePreChangeEvent(cev);
            }
        }
    }
}

