/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBWrapper;

public class CachingSequenceDB
extends SequenceDBWrapper {
    private transient Map cache = new HashMap();

    public CachingSequenceDB(SequenceDB parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return this.getParent().getName();
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        Sequence seq;
        SoftReference ref = (SoftReference)this.cache.get(id);
        if (ref == null) {
            seq = this.getParent().getSequence(id);
            this.cache.put(id, new SoftReference<Sequence>(seq));
        } else {
            seq = (Sequence)ref.get();
            if (seq == null) {
                seq = this.getParent().getSequence(id);
                this.cache.put(id, new SoftReference<Sequence>(seq));
            }
        }
        return seq;
    }

    @Override
    public Set ids() {
        return this.getParent().ids();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cache = new HashMap();
    }
}

