/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class LazyFeatureHolder
extends AbstractChangeable
implements FeatureHolder {
    private FeatureHolder featureHolder;
    private Forwarder changeForwarder;
    private FeatureFilter schema;

    protected LazyFeatureHolder() {
    }

    protected LazyFeatureHolder(FeatureFilter schema) {
        this.schema = schema;
    }

    @Override
    public FeatureFilter getSchema() {
        if (this.schema == null) {
            return this.getFeatureHolder().getSchema();
        }
        return this.schema;
    }

    protected abstract FeatureHolder createFeatureHolder();

    protected void flushFeatures() {
        this.featureHolder = null;
    }

    private FeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = this.createFeatureHolder();
            if (!this.hasListeners()) {
                this.changeForwarder = new Forwarder();
                this.featureHolder.addChangeListener(this.changeForwarder, ChangeType.UNKNOWN);
            }
        }
        return this.featureHolder;
    }

    public Iterator features() {
        return this.getFeatureHolder().features();
    }

    @Override
    public int countFeatures() {
        return this.getFeatureHolder().countFeatures();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatureHolder().filter(ff);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (!recurse) {
            if (FilterUtils.areDisjoint(ff, this.getSchema())) {
                return FeatureHolder.EMPTY_FEATURE_HOLDER;
            }
            if (FilterUtils.areProperSubset(ff, this.getSchema())) {
                return this;
            }
        }
        return this.getFeatureHolder().filter(ff, recurse);
    }

    @Override
    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        return this.getFeatureHolder().createFeature(template);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatureHolder().removeFeature(f);
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getFeatureHolder().containsFeature(f);
    }

    @Override
    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport changeSupport = super.getChangeSupport(ct);
        if (this.featureHolder != null) {
            this.changeForwarder = new Forwarder();
            this.featureHolder.addChangeListener(this.changeForwarder, ChangeType.UNKNOWN);
        }
        return changeSupport;
    }

    private class Forwarder
    implements ChangeListener {
        private Forwarder() {
        }

        @Override
        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            LazyFeatureHolder.this.getChangeSupport(cev.getType()).firePreChangeEvent(cev);
        }

        @Override
        public void postChange(ChangeEvent cev) {
            LazyFeatureHolder.this.getChangeSupport(cev.getType()).firePostChangeEvent(cev);
        }
    }
}

