/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public interface FilterTest {
    public boolean accept(Object var1);

    public static class GreaterThan
    implements FilterTest {
        private double threshold;

        public GreaterThan(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(Object value) {
            return value instanceof String && Double.parseDouble((String)value) > this.threshold;
        }
    }

    public static class LessThan
    implements FilterTest {
        private double threshold;

        public LessThan(double threshold) {
            this.threshold = threshold;
        }

        @Override
        public boolean accept(Object value) {
            return value instanceof String && Double.parseDouble((String)value) < this.threshold;
        }
    }

    public static class FindRegex {
        private Pattern pattern;

        public FindRegex(String regex) throws PatternSyntaxException {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(Object value) {
            try {
                return this.pattern.matcher((String)value).find();
            }
            catch (ClassCastException ce) {
                return false;
            }
        }
    }

    public static class MatchRegex {
        private Pattern pattern;

        public MatchRegex(String regex) throws PatternSyntaxException {
            this.pattern = Pattern.compile(regex);
        }

        public boolean accept(Object value) {
            try {
                return this.pattern.matcher((String)value).matches();
            }
            catch (ClassCastException ce) {
                return false;
            }
        }
    }

    public static class Equals
    implements FilterTest {
        private Object value;

        public Equals(Object value) {
            this.value = value;
        }

        @Override
        public boolean accept(Object value) {
            try {
                return this.value.equals(value);
            }
            catch (ClassCastException ce) {
                return false;
            }
        }
    }
}

