/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;

public final class StructureTools {
    private static final FiniteAlphabet struct;
    private static final AtomicSymbol space;
    private static final AtomicSymbol c;
    private static final AtomicSymbol h;
    private static final AtomicSymbol g;
    private static final AtomicSymbol i;
    private static final AtomicSymbol e;
    private static final AtomicSymbol b;
    private static final AtomicSymbol t;
    private static final AtomicSymbol s;

    public FiniteAlphabet getStructure() {
        return struct;
    }

    public AtomicSymbol get_() {
        return space;
    }

    public AtomicSymbol getC() {
        return c;
    }

    public AtomicSymbol getH() {
        return h;
    }

    public AtomicSymbol getG() {
        return g;
    }

    public AtomicSymbol getI() {
        return i;
    }

    public AtomicSymbol getE() {
        return e;
    }

    public AtomicSymbol getB() {
        return b;
    }

    public AtomicSymbol getT() {
        return t;
    }

    public AtomicSymbol getS() {
        return s;
    }

    static {
        try {
            struct = (FiniteAlphabet)AlphabetManager.alphabetForName("STRUCTURE");
            SymbolTokenization sTok = struct.getTokenization("token");
            space = (AtomicSymbol)sTok.parseToken(" ");
            c = (AtomicSymbol)sTok.parseToken("c");
            h = (AtomicSymbol)sTok.parseToken("h");
            g = (AtomicSymbol)sTok.parseToken("g");
            i = (AtomicSymbol)sTok.parseToken("i");
            e = (AtomicSymbol)sTok.parseToken("e");
            b = (AtomicSymbol)sTok.parseToken("b");
            t = (AtomicSymbol)sTok.parseToken("t");
            s = (AtomicSymbol)sTok.parseToken("s");
        }
        catch (Throwable t) {
            throw new BioError("Could not initialise structure alphabet", t);
        }
    }
}

