/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Symbol;

public interface SequenceStreamer {
    public boolean hasNext();

    public void streamNext(SeqIOListener var1) throws IOException, BioException;

    public void reset() throws BioException;

    public static class FileStreamer
    implements SequenceStreamer {
        private final List fileList;
        private final SequenceFormat format;
        private final SymbolTokenization toke;
        private Iterator fileIterator;
        private BufferedReader currentStream = null;

        public FileStreamer(SequenceFormat format, SymbolTokenization toke, List files) {
            this.format = format;
            this.fileList = files;
            this.toke = toke;
            this.fileIterator = this.fileList.iterator();
        }

        public FileStreamer(SequenceFormat format, SymbolTokenization toke, File f) {
            this(format, toke, Collections.singletonList(f));
        }

        @Override
        public void reset() {
            this.currentStream = null;
            this.fileIterator = this.fileList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentStream != null || this.fileIterator.hasNext();
        }

        @Override
        public void streamNext(SeqIOListener listener) throws BioException, IOException {
            boolean more;
            if (this.currentStream == null) {
                this.currentStream = new BufferedReader(new FileReader((File)this.fileIterator.next()));
            }
            if (!(more = this.format.readSequence(this.currentStream, this.toke, listener))) {
                this.currentStream.close();
                this.currentStream = null;
            }
        }
    }

    public static class SequenceDBStreamer
    implements SequenceStreamer {
        private SequenceDB seqDB;
        private SequenceIterator si;

        public SequenceDBStreamer(SequenceDB seqDB) {
            this.seqDB = seqDB;
            this.si = seqDB.sequenceIterator();
        }

        @Override
        public boolean hasNext() {
            return this.si.hasNext();
        }

        @Override
        public void reset() {
            this.si = this.seqDB.sequenceIterator();
        }

        @Override
        public void streamNext(SeqIOListener listener) throws BioException {
            Sequence seq = this.si.nextSequence();
            System.err.println("Streaming " + seq.getName());
            listener.startSequence();
            listener.setName(seq.getName());
            listener.setURI(seq.getURN());
            Symbol[] syms = new Symbol[4096];
            int pos = 1;
            int spos = 0;
            while (pos <= seq.length()) {
                syms[spos++] = seq.symbolAt(pos++);
                if (spos != syms.length && pos <= seq.length()) continue;
                listener.addSymbols(seq.getAlphabet(), syms, 0, spos);
                spos = 0;
            }
            listener.endSequence();
        }
    }
}

