/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.HashSet;
import java.util.Set;

public interface Taxon {
    public static final Set taxa = new HashSet();
    public static final Taxon A_THALIANA = new TaxonStub(3702, "Arabidopsis thaliana");
    public static final Taxon B_TAURUS = new TaxonStub(9913, "Bos taurus");
    public static final Taxon C_ELEGANS = new TaxonStub(6239, "Caenorhabditis elegans");
    public static final Taxon D_RERIO = new TaxonStub(7955, "Danio rerio");
    public static final Taxon D_MELANOGASTER = new TaxonStub(7227, "Drosophila melanogaster");
    public static final Taxon H_SAPIENS = new TaxonStub(9606, "Homo sapiens");
    public static final Taxon H_VULGARE = new TaxonStub(4513, "Hordeum vulgare");
    public static final Taxon L_ESCULENTUM = new TaxonStub(4081, "Lycopersicon esculentum");
    public static final Taxon M_TRUNCULATA = new TaxonStub(3880, "Medicago truncatula");
    public static final Taxon M_MUSCULUS = new TaxonStub(10090, "Mus musculus");
    public static final Taxon O_SATIVA = new TaxonStub(4530, "Oryz sativa");
    public static final Taxon R_NORVEGICUS = new TaxonStub(10116, "Rattus norvegicus");
    public static final Taxon S_SCROFA = new TaxonStub(9823, "Sus scrofa");
    public static final Taxon T_AESTIVUM = new TaxonStub(4565, "Triticum aestivum");
    public static final Taxon X_LAEVIS = new TaxonStub(8355, "Xenopus laevis");
    public static final Taxon Z_MAYS = new TaxonStub(4577, "Zea mays");

    public String getDescription();

    public int getTaxonID();

    public static class TaxonStub
    implements Taxon {
        int id;
        private String description;

        TaxonStub(int id, String description) {
            this.id = id;
            this.description = description;
            taxa.add(this);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getTaxonID() {
            return this.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

