/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.blast2html;

import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.biojava.bio.program.blast2html.AbstractAlignmentStyler;

public class SimpleAlignmentStyler
extends AbstractAlignmentStyler {
    public static int SHOW_ALL = 0;
    public static int SHOW_SAME = 1;
    public static int SHOW_DIFF = 2;
    private int iStyle = 0;

    public SimpleAlignmentStyler(int piStyle) {
        if (piStyle != SHOW_DIFF && piStyle != SHOW_ALL && piStyle != SHOW_SAME) {
            throw new IllegalArgumentException("Style flag not one of SimpleAlignmentStyler.SHOW_DIFF,  SHOW_ALL or SHOW_SAME");
        }
        this.iStyle = piStyle;
    }

    protected void readColourMapFromProperties(String poFileName) {
        Properties oColourProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(poFileName);
            oColourProps.load(fis);
            fis.close();
        }
        catch (Exception e) {
            System.out.println("Failed to read properties file: " + poFileName);
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
        for (Map.Entry<Object, Object> e : oColourProps.entrySet()) {
            String oColourClass = this.getColourClass((String)e.getValue());
            this.oColourMap.put(e.getKey(), oColourClass);
        }
    }

    protected void readColourMap() {
        String oPropFileName = System.getProperty("colourMap");
        if (oPropFileName == null) {
            System.err.println("No ColourMap preference file specified with -DcolourMap=<filename>");
        } else {
            this.readColourMapFromProperties(oPropFileName);
        }
    }

    @Override
    public void getStyle(String poFirst, String poSecond, String[] poStyleHolder) {
        poStyleHolder[0] = (String)this.oColourMap.get(poFirst);
        poStyleHolder[1] = (String)this.oColourMap.get(poSecond);
        if (this.iStyle == SHOW_SAME) {
            if (poStyleHolder[0] != poStyleHolder[1]) {
                poStyleHolder[0] = null;
                poStyleHolder[1] = null;
            }
        } else if (this.iStyle == SHOW_DIFF && poStyleHolder[0] == poStyleHolder[1]) {
            poStyleHolder[0] = null;
            poStyleHolder[1] = null;
        }
    }
}

