/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.molbio.RestrictionSiteFinder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.utils.ThreadPool;

public class RestrictionMapper
implements SequenceAnnotator {
    public static final String SITE_FEATURE_SOURCE = "regex";
    public static final String SITE_FEATURE_TYPE = "misc_binding";
    private List restrictionEnzymes = new ArrayList();
    private boolean mapAll = false;
    private ThreadPool threadPool;
    private ExecutorService tserv;

    public RestrictionMapper(ThreadPool threadPool) {
        this();
        this.threadPool = threadPool;
    }

    public RestrictionMapper(ExecutorService xser) {
        this();
        this.tserv = xser;
    }

    private RestrictionMapper() {
    }

    @Override
    public Sequence annotate(Sequence sequence) {
        ViewSequence mapped = new ViewSequence(sequence);
        if (this.tserv == null) {
            for (int i = 0; i < this.restrictionEnzymes.size(); ++i) {
                RestrictionEnzyme enzyme = (RestrictionEnzyme)this.restrictionEnzymes.get(i);
                this.threadPool.addRequest(new RestrictionSiteFinder(enzyme, this.mapAll, mapped));
            }
            this.threadPool.waitForThreads();
        } else {
            HashSet<CallableSiteFinder> taskPool = new HashSet<CallableSiteFinder>();
            for (int i = 0; i < this.restrictionEnzymes.size(); ++i) {
                RestrictionEnzyme enzyme = (RestrictionEnzyme)this.restrictionEnzymes.get(i);
                taskPool.add(new CallableSiteFinder(new RestrictionSiteFinder(enzyme, this.mapAll, mapped)));
            }
            try {
                List lFut = this.tserv.invokeAll(taskPool);
                for (Future future : lFut) {
                    RestrictionEnzyme re = null;
                    try {
                        re = (RestrictionEnzyme)future.get();
                    }
                    catch (ExecutionException ex) {
                        Logger.getLogger(RestrictionMapper.class.getName()).log(Level.SEVERE, "An error occurred during the mapping with the enzyme: " + re != null ? re.toString() : "unknown of the sequence: " + sequence.getName(), ex);
                    }
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(RestrictionMapper.class.getName()).log(Level.SEVERE, "Restriction mapping interrupted for sequence: " + sequence.getName(), ex);
            }
        }
        return mapped;
    }

    public boolean getMapAll() {
        return this.mapAll;
    }

    public void setMapAll(boolean on) {
        this.mapAll = on;
    }

    public void addEnzyme(RestrictionEnzyme enzyme) {
        if (this.restrictionEnzymes.contains(enzyme)) {
            throw new IllegalArgumentException("RestrictionMapper is already mapping '" + enzyme + "'");
        }
        this.restrictionEnzymes.add(enzyme);
    }

    public void removeEnzyme(RestrictionEnzyme enzyme) {
        if (!this.restrictionEnzymes.contains(enzyme)) {
            throw new IllegalArgumentException("RestrictionMapper is not mapping '" + enzyme + "'");
        }
        this.restrictionEnzymes.remove(enzyme);
    }

    public void clearEnzymes() {
        this.restrictionEnzymes.clear();
    }

    private class CallableSiteFinder
    implements Callable<RestrictionEnzyme> {
        RestrictionSiteFinder finder;

        CallableSiteFinder(RestrictionSiteFinder finder) {
            this.finder = finder;
        }

        @Override
        public RestrictionEnzyme call() throws Exception {
            this.finder.run();
            return this.finder.getEnzyme();
        }
    }
}

