#!/bin/bash

if [ "$#" -eq 0 ]; then
  echo "Usage: $0 catalog_path [chr_list]" >&2
  echo "   chr_list defaults to '1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y M'"
  echo "   e.g. $0 catalog.tsv.bgz \"1 10 12\" will look for dups in catalog.tsv.bgz for chrs 1, 10 and 12"
  exit 1
fi

command -v bior_drill >/dev/null 2>&1 || { echo >&2 "Can't find bior_drill"; exit 1; }

catalog_path=$1
shift
if [ ! -e "$catalog_path" ]; then
   echo "catalog '$catalog_path' doesn't exist"
   exit 1
fi

chrs="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y"
if [ "$#" -ne 0 ]; then
   chrs=$1
   shift
fi

if [ "$#" -ne 0 ]; then
   echo "Extra args after chr list ($chrs) ignored"
fi

for c in $chrs; do
   echo "$c dups"
   tabix $catalog_path $c | bior_drill -p _refAllele -p _altAlleles | sort | uniq -d
done
