read -p "WARNING!  This will overwrite existing expected test files.  Proceed?  (YES/NO): " answer
if [ "$answer" != "YES" ] ; then
  echo "Exiting.  No changes."
  exit;
fi

set -exu

BIOR_TEST=/research/bsi/development/Bior/Test
dbsnp=$BIOR_CATALOG/dbSNP/137/00-All_GRCh37.tsv.bgz
genes=$BIOR_CATALOG/NCBIGene/GRCh37_p10/genes.tsv.bgz
vcfs=/research/bsi/development/Bior/DeployToolkit/Vcfs
vcf1=$vcfs/sampleVariants50.vcf
vcf2=$vcfs/sample_rawvariants.20a.vcf
vcf3=$vcfs/sample_rawvariants.20b.vcf
vcf4=$vcfs/sample_rawvariants.10k.vcf

## 1) 
zcat $dbsnp | head -100 | bior_drill -p INFO.GENEINFO > 1.out

## 2)
zcat $dbsnp | head -100 | bior_overlap -d $genes > 2.out

## 3)
cat $vcf1 | bior_vcf_to_tjson | bior_same_variant -d $dbsnp \
  | bior_drill -p _id | bior_lookup -d $dbsnp -p ID > 3.out

## 4)
cat $vcf1 | bior_vcf_to_tjson | bior_annotate > 4.out

## 5)
# NOT IMPLEMENTED YET - THIS DEALS WITH DRILLING A JSON OBJECT (NOT AN INDIVIDUAL KEY-VALUE PAIR)


## 6)
cat $vcf1 | bior_vcf_to_tjson | bior_drill -p INFO -k > 6.out

## 7)
cat $vcf1 | bior_vcf_to_tjson | bior_pretty_print > 7.out

## 8)
cat $vcf1 | bior_vcf_to_tjson | bior_overlap -d $dbsnp | bior_tjson_to_vcf > 8.out

## 9)
echo -e "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n22\t29138293\t.\tT\tC\t.\t.\t." | bior_vep --all > 9.out

##10)
echo -e "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n22\t29138293\t.\tT\tC\t.\t.\t." | bior_vep > 10.out

##11)
bior_concat -o 11.gz -i $vcf2  $vcf3

##12)
bior_merge -o 12.gz -i $vcf2  $vcf3

##13)
diff <(zcat 11.gz | grep -v "^##") <(zcat 12.gz | grep -v "^##")


##20)
cat TempV4/my.txt | bior_tjson_to_vcf -c 2 -r 1 > Expected/20.expected

##100)
bior_annotate_blaster  $vcf4   100.vcf.gz  3000  Meiners.Michael1@mayo.edu

##101) 
bior_annotate < $vcf4 | gzip -c > 101.vcf.annot.gz

##102)
#(just a diff of previous two commands)
