/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.genomicutils.refassembly;

import edu.mayo.genomicutils.refassembly.AssemblyNotSupportedException;
import edu.mayo.genomicutils.refassembly.RefAssembly;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefAssemblyFinder {
    private static String REF_ASSEMBLY_BASE_DIR = null;
    protected final String REF_ASSEMBLY_BASE_DIR_PROPKEY = "refAssemblyBaseDir";
    private String mRefAssemblyPropsPath = "/refAssembly.properties";

    public static void setRefAssemblyBaseDirStatic(String refAssemblyBaseDir) {
        REF_ASSEMBLY_BASE_DIR = refAssemblyBaseDir;
    }

    public static String getRefAssemblyBaseDirStatic() {
        return REF_ASSEMBLY_BASE_DIR;
    }

    public List<RefAssembly> listReferenceAssemblyCatalogs(String baseDir) throws IOException {
        File baseDirFile = new File(baseDir);
        File[] filesInDir = baseDirFile.listFiles();
        ArrayList<RefAssembly> refAssemblyCatalogs = new ArrayList<RefAssembly>();
        if (filesInDir == null) {
            return refAssemblyCatalogs;
        }
        for (File file : filesInDir) {
            String assemblyShortName;
            if (file.isDirectory()) {
                refAssemblyCatalogs.addAll(this.listReferenceAssemblyCatalogs(file.getCanonicalPath()));
                continue;
            }
            if (!file.getName().endsWith(".tsv.bgz") || (assemblyShortName = this.getAssemblyNameFromPath(file)) == null) continue;
            refAssemblyCatalogs.add(new RefAssembly(assemblyShortName, file.getCanonicalPath()));
        }
        Collections.sort(refAssemblyCatalogs, this.getRefAssemblyComparator());
        return refAssemblyCatalogs;
    }

    private Comparator<RefAssembly> getRefAssemblyComparator() {
        return new Comparator<RefAssembly>(){

            @Override
            public int compare(RefAssembly ref1, RefAssembly ref2) {
                return ref1.name.compareToIgnoreCase(ref2.name);
            }
        };
    }

    private String getAssemblyNameFromPath(File file) {
        do {
            String filename = file.getName().toLowerCase();
            if (!file.isDirectory() || !filename.startsWith("hg") && !filename.startsWith("grch")) continue;
            return file.getName();
        } while ((file = file.getParentFile()) != null);
        return null;
    }

    public String getFullPathToRefAssemblyCatalog(String baseDir, String refAssemblyName) throws AssemblyNotSupportedException, IOException {
        List<RefAssembly> refAssemblyList = this.listReferenceAssemblyCatalogs(baseDir);
        for (RefAssembly refAssembly : refAssemblyList) {
            if (!refAssembly.name.equalsIgnoreCase(refAssemblyName)) continue;
            return refAssembly.fullPath;
        }
        throw new AssemblyNotSupportedException(baseDir, refAssemblyName);
    }

    public String getBaseDirForRefAssemblyCatalogs() throws IOException {
        String refAssemblyBaseDir = this.getBaseDirFromStaticVar();
        if (refAssemblyBaseDir == null) {
            refAssemblyBaseDir = this.getBaseDirFromSystemVar();
        }
        if (refAssemblyBaseDir == null) {
            refAssemblyBaseDir = this.getBaseDirFromBiorConfig();
        }
        if (refAssemblyBaseDir == null) {
            refAssemblyBaseDir = this.getBaseDirFromProjectPropsFile();
        }
        return refAssemblyBaseDir;
    }

    protected String getBaseDirFromStaticVar() {
        return REF_ASSEMBLY_BASE_DIR;
    }

    protected String getBaseDirFromSystemVar() {
        return this.getSysVar("refAssemblyBaseDir");
    }

    protected String getSysVar(String key) {
        String envVarValue = System.getProperty(key);
        if (envVarValue == null) {
            envVarValue = System.getenv().get(key);
        }
        return envVarValue;
    }

    protected String getBaseDirFromBiorConfig() throws IOException {
        String biorHome = this.getSysVar("BIOR_LITE_HOME");
        if (biorHome == null || biorHome.length() == 0) {
            return null;
        }
        File biorConfigFile = new File(biorHome + "/conf/bior.properties");
        if (!biorConfigFile.exists()) {
            return null;
        }
        Properties props = this.loadProps(biorConfigFile);
        return props.getProperty("refAssemblyBaseDir");
    }

    protected void setRefAssemblyPropsFilePath(String refAssemblyPropsFilePath) {
        this.mRefAssemblyPropsPath = refAssemblyPropsFilePath;
    }

    protected String getBaseDirFromProjectPropsFile() throws IOException {
        URL url = this.getClass().getResource(this.mRefAssemblyPropsPath);
        if (url == null) {
            return null;
        }
        Properties projectProps = this.loadProps(new File(url.getFile()));
        String baseDir = projectProps.getProperty("refAssemblyBaseDir");
        return baseDir;
    }

    protected Properties loadProps(File biorSysPropsFile) throws IOException {
        Properties props;
        block2: {
            props = new Properties();
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(biorSysPropsFile);
                props.load(fin);
            }
            catch (Exception e) {
                if (fin == null) break block2;
                fin.close();
            }
        }
        return props;
    }
}

