/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.jmock.internal.Formatting;

public class Cardinality
implements SelfDescribing {
    public static final Cardinality ALLOWING = Cardinality.atLeast(0);
    private final int required;
    private final int maximum;

    public Cardinality(int required, int maximum) {
        this.required = required;
        this.maximum = maximum;
    }

    public static Cardinality exactly(int count) {
        return Cardinality.between(count, count);
    }

    public static Cardinality atLeast(int required) {
        return Cardinality.between(required, Integer.MAX_VALUE);
    }

    public static Cardinality between(int required, int maximum) {
        return new Cardinality(required, maximum);
    }

    public static Cardinality atMost(int maximum) {
        return Cardinality.between(0, maximum);
    }

    public boolean isSatisfied(int invocationsSoFar) {
        return this.required <= invocationsSoFar;
    }

    public boolean allowsMoreInvocations(int invocationCount) {
        return invocationCount < this.maximum;
    }

    public void describeTo(Description description) {
        if (this.required == 0 && this.maximum == Integer.MAX_VALUE) {
            description.appendText("allowed");
        } else {
            description.appendText("expected ");
            if (this.required == 0 && this.maximum == 0) {
                description.appendText("never");
            } else if (this.required == 1 && this.maximum == 1) {
                description.appendText("once");
            } else if (this.required == this.maximum) {
                description.appendText("exactly ");
                description.appendText(Formatting.times(this.required));
            } else if (this.maximum == Integer.MAX_VALUE) {
                description.appendText("at least ");
                description.appendText(Formatting.times(this.required));
            } else if (this.required == 0) {
                description.appendText("at most ");
                description.appendText(Formatting.times(this.maximum));
            } else {
                description.appendText(Integer.toString(this.required));
                description.appendText(" to ");
                description.appendText(Formatting.times(this.maximum));
            }
        }
    }
}

