/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.util.FieldProcessorBase;

public class TextCleaner
extends FieldProcessorBase {
    private String start;
    private String middle;
    private String replace;
    private String end;
    private int startLen;
    private int middleLen;
    private int replaceLen;
    private int endLen;

    public TextCleaner(String start, String end) {
        this(start, null, null, end);
    }

    public TextCleaner(String start, String middle, String replace, String end) {
        this.start = start;
        this.middle = middle;
        this.replace = replace;
        this.end = end;
        this.startLen = start == null ? 0 : start.length();
        this.middleLen = middle == null ? 0 : middle.length();
        this.replaceLen = replace == null ? 0 : replace.length();
        this.endLen = end == null ? 0 : end.length();
    }

    @Override
    public String process(String value) {
        boolean hasEnd;
        if (super.isBlank(value)) {
            return gCurBlankValue;
        }
        boolean hasStart = this.startLen > 0 ? value.startsWith(this.start) : false;
        boolean bl = hasEnd = this.endLen > 0 ? value.endsWith(this.end) : false;
        if (this.middleLen > 0) {
            return this.processReplace(value, hasStart, hasEnd);
        }
        return this.processNoReplace(value, hasStart, hasEnd);
    }

    private String processNoReplace(String value, boolean hasStart, boolean hasEnd) {
        if (hasStart) {
            if (hasEnd) {
                return value.substring(this.startLen, value.length() - this.endLen);
            }
            return value.substring(this.startLen);
        }
        if (hasEnd) {
            return value.substring(0, value.length() - this.endLen);
        }
        return value;
    }

    private String processReplace(String value, boolean hasStart, boolean hasEnd) {
        int curEnd;
        int curStart = hasStart ? this.startLen : 0;
        int foundPos = value.indexOf(this.middle, curStart);
        int n = curEnd = hasEnd ? value.length() - this.endLen : value.length();
        if (foundPos < 0 || foundPos + this.middleLen > curEnd) {
            return value.substring(curStart, curEnd);
        }
        int curSize = curEnd - curStart;
        StringBuilder hold = new StringBuilder(curSize);
        do {
            hold.append(value.substring(curStart, foundPos));
            if (this.replaceLen <= 0) continue;
            hold.append(this.replace);
        } while ((foundPos = value.indexOf(this.middle, curStart = foundPos + this.middleLen)) >= 0 && foundPos + this.middleLen <= curEnd);
        hold.append(value.substring(curStart, curEnd));
        return hold.toString();
    }
}

