/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.mayo.bior.pipeline.VEP.VepCsqComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VepFunctions {
    private VepCsqComparator mVepCsqComparator = new VepCsqComparator();
    private List<String> mVepCsqHeaders = new ArrayList<String>();
    public static final String VEP_ERROR_MSG = "VEPERRORMessage";

    public VepFunctions() {
        this(null);
    }

    public VepFunctions(List<String> vepCsqHeaders) {
        this.mVepCsqHeaders = vepCsqHeaders;
        if (this.mVepCsqHeaders == null || this.mVepCsqHeaders.size() == 0) {
            this.mVepCsqHeaders = new ArrayList<String>(Arrays.asList("Allele", "Gene", "Feature", "Feature_type", "Consequence", "cDNA_position", "CDS_position", "Protein_position", "Amino_acids", "Codons", "Existing_variation", "HGNC", "DISTANCE", "SIFT", "PolyPhen", "CELL_TYPE"));
        }
    }

    public JsonArray vepCsqToJsonList(String vepCsq) {
        JsonArray jsonArray = new JsonArray();
        if (vepCsq.contains("VEPERR")) {
            JsonObject jObj = new JsonObject();
            jObj.addProperty("VEPMessage", VEP_ERROR_MSG);
            jObj.addProperty("Status", "VEP failed to assign function to this variant");
            jsonArray.add((JsonElement)jObj);
        } else {
            String[] vepCsqItems;
            for (String csqItem : vepCsqItems = vepCsq.replace("CSQ=", "").split(",")) {
                jsonArray.add((JsonElement)this.vepCsqToJson(csqItem));
            }
        }
        return jsonArray;
    }

    private JsonObject vepCsqToJson(String vepCsqItem) {
        boolean isPolyphenScoresGiven;
        boolean isSiftScoresGiven;
        String[] vepParts = vepCsqItem.split("\\|");
        JsonObject jsonObj = new JsonObject();
        for (int i = 0; i < Math.min(vepParts.length, this.mVepCsqHeaders.size()); ++i) {
            if ("".equals(vepParts[i])) continue;
            jsonObj.addProperty(this.mVepCsqHeaders.get(i), vepParts[i]);
        }
        boolean bl = isSiftScoresGiven = vepParts.length > 13 && vepParts[13].contains("(") && vepParts[13].contains(")");
        if (isSiftScoresGiven) {
            Effect sift = this.parseEffect(vepParts[13]);
            jsonObj.addProperty("SIFT_TERM", sift.term);
            jsonObj.addProperty("SIFT_Score", (Number)sift.score);
        }
        boolean bl2 = isPolyphenScoresGiven = vepParts.length > 14 && vepParts[14].contains("(") && vepParts[14].contains(")");
        if (isPolyphenScoresGiven) {
            Effect polyphen = this.parseEffect(vepParts[14]);
            jsonObj.addProperty("PolyPhen_TERM", polyphen.term);
            jsonObj.addProperty("PolyPhen_Score", (Number)polyphen.score);
        }
        return jsonObj;
    }

    private Effect parseEffect(String effStr) {
        int idxOpenParen = effStr.indexOf("(");
        int idxCloseParen = effStr.indexOf(")");
        if (idxOpenParen == -1 || idxCloseParen == -1) {
            return null;
        }
        Effect effect = new Effect();
        effect.term = effStr.substring(0, idxOpenParen);
        effect.score = Double.parseDouble(effStr.substring(idxOpenParen + 1, idxCloseParen));
        return effect;
    }

    public JsonObject getWorstCase(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        List<JsonObject> jsonObjList = this.jsonArrayToList(jsonArray);
        Collections.sort(jsonObjList, this.mVepCsqComparator);
        return jsonObjList.get(0);
    }

    protected List<JsonObject> jsonArrayToList(JsonArray jsonArray) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObj = jsonArray.get(i).getAsJsonObject();
            list.add(jsonObj);
        }
        return list;
    }

    class Effect {
        public String term;
        public Double score;

        Effect() {
        }
    }
}

