/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class GenomicObjectUtils {
    public static final String DELIMTOKEN = ";#__#;";
    public static final HashMap<String, String> CHROM_MAP = new HashMap();

    public static char getStrand(String s) {
        if (s.contains("+")) {
            return '+';
        }
        if (s.contains("-")) {
            return '-';
        }
        return '.';
    }

    public static String stringifyList(List<String> l) {
        Collections.sort(l);
        StringBuilder sb = new StringBuilder();
        for (String ele : l) {
            sb.append(ele);
            sb.append(DELIMTOKEN);
        }
        return sb.toString();
    }

    public static List<String> listifyString(String s) {
        return Arrays.asList(s.split(DELIMTOKEN));
    }

    public static char computeStrandFromNumbers(int strand) {
        return GenomicObjectUtils.computeStrandFromNumbers(new Integer(strand));
    }

    public static char computeStrandFromNumbers(String strand) {
        if (strand.equalsIgnoreCase("-1")) {
            return '-';
        }
        if (strand.equalsIgnoreCase("-1")) {
            return '+';
        }
        return '.';
    }

    public static String computechr(String raw) {
        String result = CHROM_MAP.get(GenomicObjectUtils.removeChrPrefixAndCapitalize(raw));
        if (result != null) {
            return result;
        }
        return raw;
    }

    private static Object removeChrPrefixAndCapitalize(String raw) {
        String chr = raw.toUpperCase();
        if (chr.startsWith("CHR") && chr.length() > 3) {
            chr = chr.substring(3);
        } else if (chr.startsWith("C") && chr.length() > 1) {
            chr = chr.substring(1);
        }
        return chr;
    }

    public static void printConversionTable() {
        GenomicObjectUtils.printConversionTable(System.out);
    }

    public static void printConversionTable(PrintStream out) {
        TreeSet<String> keys = new TreeSet<String>(CHROM_MAP.keySet());
        out.println("input -> output");
        for (String key : keys) {
            out.print(key);
            out.print(" -> ");
            out.println(CHROM_MAP.get(key));
        }
    }

    static {
        CHROM_MAP.put("M", "M");
        CHROM_MAP.put("MT", "M");
        CHROM_MAP.put("26", "M");
        CHROM_MAP.put("XY", "XY");
        CHROM_MAP.put("25", "XY");
        CHROM_MAP.put("Y", "Y");
        CHROM_MAP.put("24", "Y");
        CHROM_MAP.put("X", "X");
        CHROM_MAP.put("23", "X");
        for (int i = 1; i <= 22; ++i) {
            CHROM_MAP.put(i + "", i + "");
        }
    }
}

