/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataVerificationMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.lang.StringUtils;

public class ColumnMetaDataOperations {
    private File columnsTsvFile;

    public ColumnMetaDataOperations() {
    }

    public ColumnMetaDataOperations(File columnsTsv) {
        this.columnsTsvFile = columnsTsv;
    }

    public File getColumnsTsv() {
        return this.columnsTsvFile;
    }

    public void setColumnsTsv(File columnsTsv) {
        this.columnsTsvFile = columnsTsv;
    }

    public HashMap<String, ColumnMetaData> load() throws IOException {
        LinkedHashMap<String, ColumnMetaData> colMetaMap = new LinkedHashMap<String, ColumnMetaData>();
        List<ColumnMetaData> colList = this.loadAsList();
        for (ColumnMetaData col : colList) {
            colMetaMap.put(col.getColumnName(), col);
        }
        return colMetaMap;
    }

    public List<ColumnMetaData> loadAsList() throws IOException {
        String line;
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        BufferedReader reader = new BufferedReader(new FileReader(this.columnsTsvFile));
        ArrayList<String> headerRows = new ArrayList<String>();
        Map<String, Integer> colHeaderMap = new HashMap<String, Integer>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) {
                headerRows.add(line);
                boolean isColumnHeaderRow = line.startsWith("#") && !line.startsWith("##");
                if (!isColumnHeaderRow) continue;
                colHeaderMap = this.getColHeaderMap(line);
                continue;
            }
            String[] columns = line.split("\t");
            String key = this.getColVal(colHeaderMap, ColumnHeader.ColumnName, columns, "");
            String typeStr = this.getColVal(colHeaderMap, ColumnHeader.Type, columns, null);
            String count = this.getColVal(colHeaderMap, ColumnHeader.Count, columns, "");
            String desc = this.getColVal(colHeaderMap, ColumnHeader.Description, columns, "");
            String human = this.getColVal(colHeaderMap, ColumnHeader.HumanReadableName, columns, "");
            if (desc.equals(".") || desc.trim().length() == 0) {
                desc = "";
            }
            if (human.equals(".") || human.trim().length() == 0) {
                human = "";
            }
            if (key.contains("\"")) {
                System.err.println("Warning: the ColumnName in columns.tsv contains a double-quote which would mess up any downstream VCF validators.  Converting these to single-quotes.  Offending Line: [" + line + "].  File: " + this.columnsTsvFile);
                key = key.replaceAll("\"", "'");
            }
            if (human.contains("\"")) {
                System.err.println("Warning: the HumanReadableName in columns.tsv contains a double-quote which would mess up any downstream VCF validators.  Converting these to single-quotes.  Offending Line: [" + line + "].  File: " + this.columnsTsvFile);
                human = human.replaceAll("\"", "'");
            }
            if (desc.contains("\"")) {
                System.err.println("Warning: the Description in columns.tsv contains a double-quote which would mess up any downstream VCF validators.  Converting these to single-quotes.  Offending Line: [" + line + "].  File: " + this.columnsTsvFile);
                desc = desc.replaceAll("\"", "'");
            }
            ColumnMetaData colMeta = new ColumnMetaData(key, typeStr, count, desc, human);
            colMeta.setHeaderRows(headerRows);
            colMeta.setOriginalRowInFile(line);
            colMetaList.add(colMeta);
        }
        reader.close();
        return colMetaList;
    }

    private String getColVal(Map<String, Integer> colHeaderMap, ColumnHeader columnName, String[] columns, String defaultValue) {
        Integer colIdx = colHeaderMap.get(columnName.name());
        if (colIdx == null && colHeaderMap.size() <= 1) {
            colIdx = this.getColIdxFromOriginalFormat(columnName);
        }
        if (colIdx != null && colIdx < columns.length) {
            return columns[colIdx].trim();
        }
        return defaultValue;
    }

    private Integer getColIdxFromOriginalFormat(ColumnHeader col) {
        if (col.equals((Object)ColumnHeader.ColumnName)) {
            return 0;
        }
        if (col.equals((Object)ColumnHeader.Type)) {
            return 1;
        }
        if (col.equals((Object)ColumnHeader.Count)) {
            return 2;
        }
        if (col.equals((Object)ColumnHeader.Description)) {
            return 3;
        }
        if (col.equals((Object)ColumnHeader.HumanReadableName)) {
            return 4;
        }
        return null;
    }

    private Map<String, Integer> getColHeaderMap(String line) {
        if (line.startsWith("#")) {
            line = line.replace("#", "");
        }
        String[] colHeaders = line.split("\t");
        HashMap<String, Integer> colHeaderNameToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < colHeaders.length; ++i) {
            colHeaderNameToIndexMap.put(colHeaders[i], i);
        }
        return colHeaderNameToIndexMap;
    }

    public void save(List<ColumnMetaData> colMetaList) throws IOException {
        this.save(colMetaList, false);
    }

    public void save(List<ColumnMetaData> colMetaList, boolean isForceOverwrite) throws IOException {
        if (!isForceOverwrite && this.columnsTsvFile.exists()) {
            throw new FileExistsException(this.columnsTsvFile);
        }
        FileOutputStream fout = new FileOutputStream(this.columnsTsvFile);
        List<String> headerLines = this.getDefaultColumnsTsvHeader();
        if (colMetaList.size() > 0 && colMetaList.get(0).getHeaderRows().size() > 0) {
            headerLines = colMetaList.get(0).getHeaderRows();
        }
        fout.write(this.getLinesAsString(headerLines).getBytes());
        for (ColumnMetaData colMeta : colMetaList) {
            this.setHumanReadableNameToKeyIfBlank(colMeta);
            fout.write((colMeta.toString() + "\n").getBytes());
        }
        fout.close();
    }

    private void setHumanReadableNameToKeyIfBlank(ColumnMetaData colMeta) {
        if (!this.isGiven(colMeta.getHumanReadableName())) {
            colMeta.setHumanReadableName(colMeta.getColumnName());
        }
    }

    public String getLinesAsString(List<String> headerLines) {
        StringBuilder str = new StringBuilder();
        for (String headerRow : headerLines) {
            str.append(headerRow + "\n");
        }
        return str.toString();
    }

    public List<String> getDefaultColumnsTsvHeader() {
        ArrayList<String> headerLines = new ArrayList<String>();
        headerLines.add("##-----------------------------------------------------");
        headerLines.add("## Catalog field definitions");
        headerLines.add("##-----------------------------------------------------");
        headerLines.add("## ColumnName = The key or column name");
        headerLines.add("## Type = The type of the object, as can be determined from parsing the VCF file or taking an educated guess based on the catalog values (Possible values: JSON, String, Integer, Float, Boolean)");
        headerLines.add("## Count = The number of values that repeatedly occur  (Possible values: 0 (Boolean), 1 (JSON,Integer,Float,String), or '.' for variable or unknown number of values.  JsonArrays will be resolved to other primitives such as String,Integer,Float, and will have a count of '.'");
        headerLines.add("## Description = The description of the ColumnName");
        headerLines.add("## HumanReadableName = A more readable name than ColumnName but typically not as long as Description.");
        headerLines.add("##------------------------------------------------------------------");
        headerLines.add("#ColumnName\tType\tCount\tDescription\tHumanReadableName");
        return headerLines;
    }

    public List<ColumnMetaData> merge(List<ColumnMetaData> colMetaListMain, List<ColumnMetaData> colMetaListAdditional) {
        HashSet<String> colNamesAlreadyAdded = new HashSet<String>();
        ArrayList<ColumnMetaData> mergedList = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData colMeta : colMetaListMain) {
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.getColumnName());
        }
        for (ColumnMetaData colMeta : colMetaListAdditional) {
            if (colNamesAlreadyAdded.contains(colMeta.getColumnName())) continue;
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.getColumnName());
        }
        return mergedList;
    }

    public ColumnMetaDataVerificationMessages verifyContents() throws IOException {
        List<ColumnMetaData> columnMetaList = this.loadAsList();
        ColumnMetaDataVerificationMessages errorAndWarningMsgs = new ColumnMetaDataVerificationMessages(this.columnsTsvFile);
        ArrayList<String> warningsKeysWithDescNotFound = new ArrayList<String>();
        ArrayList<String> warningsKeysWithHumanReadableNameNotFound = new ArrayList<String>();
        ArrayList<String> warningsKeysWithHumanReadableNameSameAsId = new ArrayList<String>();
        ArrayList<String> errorsKeysWithKeyThatStartsWithDot = new ArrayList<String>();
        ArrayList<String> errorsKeysWithTypeNull = new ArrayList<String>();
        ArrayList<String> errorsKeysWithBadCount = new ArrayList<String>();
        ArrayList<String> errorsKeysDuplicate = new ArrayList<String>();
        ArrayList<String> errorsKeysWithDuplicateHumanReableName = new ArrayList<String>();
        ArrayList<String> keysAlreadySeen = new ArrayList<String>();
        ArrayList<String> humanReadableNamesAlreadySeen = new ArrayList<String>();
        for (ColumnMetaData colMeta : columnMetaList) {
            boolean isValidCount;
            String key = colMeta.getColumnName();
            if (!this.isGiven(colMeta.getDescription())) {
                warningsKeysWithDescNotFound.add(key);
            }
            if (!this.isGiven(colMeta.getHumanReadableName())) {
                warningsKeysWithHumanReadableNameNotFound.add(key);
            }
            if (key.equals(colMeta.getHumanReadableName())) {
                warningsKeysWithHumanReadableNameSameAsId.add(key);
            }
            if (!this.isGiven(colMeta.getColumnName())) {
                String line = colMeta.getOriginalRowInFile();
                if (!this.isGiven(line)) {
                    line = colMeta.toString();
                }
                errorAndWarningMsgs.addError("The ColumnName must have a value.  Offending line: [" + line + "]");
            }
            if (colMeta.getDescription().contains("\"") || colMeta.getColumnName().contains("\"") || colMeta.getHumanReadableName().contains("\"")) {
                errorAndWarningMsgs.addError("The Description (or ColumnName or HumanReadableName) contains a double-quote.  Offending line: [" + colMeta.getOriginalRowInFile() + "]");
            }
            if (colMeta.getColumnName().trim().startsWith(".")) {
                errorsKeysWithKeyThatStartsWithDot.add(key);
            }
            if (colMeta.getType() == null) {
                errorsKeysWithTypeNull.add(key);
            }
            boolean bl = isValidCount = ".".equals(colMeta.getCount()) || this.isInteger(colMeta.getCount()) || "A".equalsIgnoreCase(colMeta.getCount());
            if (!this.isGiven(colMeta.getCount()) || !isValidCount) {
                errorsKeysWithBadCount.add(key);
            }
            if (keysAlreadySeen.contains(key.toLowerCase())) {
                errorsKeysDuplicate.add(key);
            }
            if (humanReadableNamesAlreadySeen.contains(colMeta.getHumanReadableName().toLowerCase())) {
                String firstKeyWithThisHumanReadableName = this.getFirstKeyWithSameHumanReadableName(columnMetaList, colMeta.getHumanReadableName());
                this.addIfNotInList(firstKeyWithThisHumanReadableName, errorsKeysWithDuplicateHumanReableName);
                this.addIfNotInList(key, errorsKeysWithDuplicateHumanReableName);
            }
            keysAlreadySeen.add(key.toLowerCase());
            humanReadableNamesAlreadySeen.add(colMeta.getHumanReadableName().toLowerCase());
        }
        if (errorsKeysWithKeyThatStartsWithDot.size() > 0) {
            errorAndWarningMsgs.addError("The ColumnName must not start with a dot.  Fix these column names: [" + StringUtils.join((Object[])errorsKeysWithKeyThatStartsWithDot.toArray(new String[0]), (String)", ") + "]");
        }
        if (errorsKeysWithTypeNull.size() > 0) {
            errorAndWarningMsgs.addError("The Type must not be null, and must be one of the accepted values.  Fix the Type for columns: [" + StringUtils.join((Object[])errorsKeysWithTypeNull.toArray(new String[0]), (String)", ") + "]");
        }
        if (errorsKeysWithBadCount.size() > 0) {
            errorAndWarningMsgs.addError("The Count must be one of these values:  a dot ('.'), an integer, or the letter 'A' (meaning there is a relationship between the count and the number of alt alleles, and these are always consistently the same).  Fix the Count for columns: [" + StringUtils.join((Object[])errorsKeysWithBadCount.toArray(new String[0]), (String)", ") + "]");
        }
        if (errorsKeysDuplicate.size() > 0) {
            errorAndWarningMsgs.addError("These ColumnNames are duplicates: [" + StringUtils.join((Object[])errorsKeysDuplicate.toArray(new String[0]), (String)", ") + "]");
        }
        if (errorsKeysWithDuplicateHumanReableName.size() > 0) {
            errorAndWarningMsgs.addError("These ColumnNames have duplicate HumanReadableNames: [" + StringUtils.join((Object[])errorsKeysWithDuplicateHumanReableName.toArray(new String[0]), (String)", ") + "]");
        }
        if (warningsKeysWithDescNotFound.size() > 0) {
            errorAndWarningMsgs.addWarning("Description not found for these columns: [" + StringUtils.join((Object[])warningsKeysWithDescNotFound.toArray(new String[0]), (String)", ") + "]");
        }
        if (warningsKeysWithHumanReadableNameNotFound.size() > 0) {
            errorAndWarningMsgs.addWarning("HumanReadableName not found for these columns: [" + StringUtils.join((Object[])warningsKeysWithHumanReadableNameNotFound.toArray(new String[0]), (String)", ") + "]");
        }
        if (warningsKeysWithHumanReadableNameSameAsId.size() > 0) {
            errorAndWarningMsgs.addWarning("HumanReadableName is set to the same value as the ColumnName for these columns: [" + StringUtils.join((Object[])warningsKeysWithHumanReadableNameSameAsId.toArray(new String[0]), (String)", ") + "]");
        }
        return errorAndWarningMsgs;
    }

    private void addIfNotInList(String item, List<String> list) {
        if (item != null && item.length() > 0 && !list.contains(item)) {
            list.add(item);
        }
    }

    private String getFirstKeyWithSameHumanReadableName(List<ColumnMetaData> columnMetaList, String humanReadableName) {
        for (ColumnMetaData colMeta : columnMetaList) {
            if (!humanReadableName.equals(colMeta.getHumanReadableName())) continue;
            return colMeta.getColumnName();
        }
        return null;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum ColumnHeader {
        ColumnName,
        Type,
        Count,
        Description,
        HumanReadableName;

    }
}

