/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import edu.mayo.pipes.bioinformatics.KeyValueHeaderPair;
import edu.mayo.pipes.bioinformatics.VCFParseException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HeaderFieldDefinitionHelpers {
    public static Map<String, KeyValueHeaderPair> getKeyValuePairsFromString(String line) {
        List<String> keyVals = HeaderFieldDefinitionHelpers.splitHandleQuotes(line, ",");
        HeaderFieldDefinitionHelpers.trim(keyVals);
        LinkedHashMap<String, KeyValueHeaderPair> keyValsMap = new LinkedHashMap<String, KeyValueHeaderPair>();
        for (String keyVal : keyVals) {
            KeyValueHeaderPair keyValPair = new KeyValueHeaderPair();
            int idxEq = keyVal.indexOf("=");
            if (idxEq == -1) {
                keyValPair.key = keyVal;
            } else {
                keyValPair.key = keyVal.substring(0, idxEq);
                String values = keyVal.substring(idxEq + 1);
                keyValPair.values = HeaderFieldDefinitionHelpers.splitHandleQuotes(values, ";");
                HeaderFieldDefinitionHelpers.trim(keyValPair.values);
            }
            keyValsMap.put(keyValPair.key, keyValPair);
        }
        return keyValsMap;
    }

    public static List<String> trim(List<String> keyVals) {
        for (int i = 0; i < keyVals.size(); ++i) {
            keyVals.set(i, keyVals.get(i).trim());
        }
        return keyVals;
    }

    public static List<String> splitHandleQuotes(String fullStr, String delimiter) {
        ArrayList<String> vals = new ArrayList<String>();
        boolean isWithinQuote = false;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fullStr.length(); ++i) {
            if (!isWithinQuote && fullStr.substring(i).startsWith(delimiter)) {
                vals.add(s.toString());
                s = new StringBuilder();
                i = i + delimiter.length() - 1;
                continue;
            }
            if (isWithinQuote && fullStr.substring(i).startsWith("\\\"")) {
                s.append("\\\"");
                ++i;
                continue;
            }
            if (fullStr.charAt(i) == '\"') {
                isWithinQuote = !isWithinQuote;
                s.append(fullStr.charAt(i));
                continue;
            }
            s.append(fullStr.charAt(i));
        }
        if (s.length() > 0) {
            vals.add(s.toString());
        }
        return vals;
    }

    public static String escapeDoubleQuotedStrings(String dblQuotedStr) {
        return dblQuotedStr.replace("\"", "\\\"").replace("\\", "\\\\");
    }

    public static String unescapeDoubleQuotedStrings(String dblQuotedStr) {
        return dblQuotedStr.replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public static String encodeSpecialChars(String in) throws UnsupportedEncodingException {
        String rightbrace = URLEncoder.encode("[", "UTF-8");
        String leftbrace = URLEncoder.encode("]", "UTF-8");
        String semicolon = URLEncoder.encode(";", "UTF-8");
        String comma = URLEncoder.encode(",", "UTF-8");
        String equals = URLEncoder.encode("=", "UTF-8");
        String out = in.replaceAll("\\[", rightbrace).replaceAll("\\]", leftbrace).replaceAll(",", comma).replaceAll(";", semicolon).replaceAll("=", equals);
        return out;
    }

    public static String decodeSpecialChars(String in) throws UnsupportedEncodingException {
        String out = in.replaceAll("%5D", "]").replaceAll("%5B", "[").replaceAll("%2C", ",").replaceAll("%3B", ";").replaceAll("%3D", "=");
        return out;
    }

    public static String stripQuotesAndUnescape(String quotedStr, boolean isRequiredToBeQuoted) throws UnsupportedEncodingException, VCFParseException {
        boolean isQuoted;
        if (quotedStr == null || quotedStr.length() == 0) {
            return "";
        }
        boolean bl = isQuoted = quotedStr.length() >= 2 && quotedStr.startsWith("\"") && quotedStr.endsWith("\"");
        if (isRequiredToBeQuoted && !isQuoted) {
            throw new VCFParseException("String must be quoted, but is not or is malformed: [" + quotedStr + "]");
        }
        return HeaderFieldDefinitionHelpers.decodeSpecialChars(HeaderFieldDefinitionHelpers.unescapeDoubleQuotedStrings(HeaderFieldDefinitionHelpers.stripQuotes(quotedStr)));
    }

    public static ValueType parseType(String typeStr) throws VCFParseException {
        try {
            return ValueType.fromString(typeStr);
        }
        catch (Exception e) {
            throw new VCFParseException(String.format("Invalid value for Type=%s", typeStr));
        }
    }

    public static Integer parseNumber(String numberStr, ValueType type) throws VCFParseException {
        if (HeaderFieldDefinitionHelpers.isAllowedNonNumericNumberValue(numberStr)) {
            return null;
        }
        try {
            Integer number = Integer.parseInt(numberStr);
            if (type.equals((Object)ValueType.Flag) && !number.equals(0)) {
                throw new VCFParseException(String.format("Invalid value for Number=%s.  Should be Number=0 if Type=Flag.", number));
            }
            return number;
        }
        catch (NumberFormatException nfe) {
            throw new VCFParseException(String.format("Invalid value for Number=%s", numberStr));
        }
    }

    private static boolean isAllowedNonNumericNumberValue(String numberStr) {
        return numberStr != null && (numberStr.equals(".") || numberStr.equalsIgnoreCase("A") || numberStr.equalsIgnoreCase("R") || numberStr.equalsIgnoreCase("G"));
    }

    public static Object getMetaValue(ValueType type, String value) throws VCFParseException {
        switch (type) {
            case Character: {
                if (value.length() != 1) {
                    throw new VCFParseException(String.format("The value %s is not a character.", value));
                }
                return Character.valueOf(value.charAt(0));
            }
            case Float: {
                try {
                    return new Float(value);
                }
                catch (NumberFormatException nfe) {
                    throw new VCFParseException(String.format("The value %s is not a float.", value));
                }
            }
            case Integer: {
                try {
                    return new Integer(value);
                }
                catch (NumberFormatException nfe) {
                    throw new VCFParseException(String.format("The value %s is not an integer.", value));
                }
            }
            case String: {
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new VCFParseException(String.format("The value %s is not UTF-8 encoded.", value));
                }
            }
        }
        return null;
    }

    public static String stripQuotes(String str) {
        if (str.length() > 1 && str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static enum ValueType {
        Integer,
        Float,
        Flag,
        Character,
        String;


        public static ValueType fromString(String s) throws Exception {
            if (s.equals(Integer.toString())) {
                return Integer;
            }
            if (s.equals(Float.toString())) {
                return Float;
            }
            if (s.equals(Flag.toString())) {
                return Flag;
            }
            if (s.equals(Character.toString())) {
                return Character;
            }
            if (s.equals(String.toString())) {
                return String;
            }
            throw new Exception("Invalid VCF type: " + s);
        }
    }
}

