/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import edu.mayo.pipes.JSON.tabix.VariantBasic;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.util.ArrayList;
import java.util.Arrays;

public class VariantJsonQuickParser {
    public VariantBasic getVariantFromJson(String json) {
        String maxBpStr;
        VariantBasic variant = new VariantBasic();
        variant.chrom = this.getJsonValFromStr(json, CoreAttributes._landmark);
        String minBpStr = this.getJsonValFromStr(json, CoreAttributes._minBP);
        if (minBpStr != null) {
            variant.minBp = this.toLong(minBpStr);
        }
        if ((maxBpStr = this.getJsonValFromStr(json, CoreAttributes._maxBP)) != null) {
            variant.maxBp = this.toLong(maxBpStr);
        }
        variant.ref = this.getJsonValFromStr(json, CoreAttributes._refAllele);
        String altsStr = this.getJsonValFromStr(json, CoreAttributes._altAlleles);
        if (altsStr != null) {
            variant.alts = new ArrayList<String>(Arrays.asList(altsStr.split(",")));
        }
        variant.rsId = this.getJsonValFromStr(json, CoreAttributes._id);
        return variant;
    }

    private Long toLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getJsonValFromStr(String jsonIn, CoreAttributes key) {
        String keyQt = "\"" + key.toString() + "\":";
        int idx = jsonIn.indexOf(keyQt);
        if (idx == -1) {
            keyQt = "'" + key.toString() + "':";
            idx = jsonIn.indexOf(keyQt);
        }
        if (idx == -1) {
            return null;
        }
        int end = jsonIn.indexOf(",", idx + keyQt.length());
        if (key.equals((Object)CoreAttributes._altAlleles)) {
            end = jsonIn.indexOf("]", idx + keyQt.length());
        }
        if (end == -1) {
            end = jsonIn.length() - 1;
        }
        String val = jsonIn.substring(idx + keyQt.length(), end).trim();
        val = val.replace("}", "").replace("[", "").replace("'", "").replace("\"", "");
        return val;
    }

    private String dequote(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

