/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class TabixParentPipe
extends AbstractPipe<History, History> {
    private List<History> mResults = new ArrayList<History>();
    protected TabixSearchPipe search;
    protected boolean isFirst = true;
    protected ComparableObjectInterface comparableObject;
    protected int historyPos = -1;
    public static final String kBlankJSON = "{}";
    protected String validResult = "";

    public TabixParentPipe(String tabixDataFile) throws IOException {
        this.init(tabixDataFile);
    }

    public TabixParentPipe(String tabixDataFile, int historyPosition) throws IOException {
        this.historyPos = historyPosition;
        this.init(tabixDataFile);
    }

    protected void init(String tabixDataFile) throws IOException {
        this.search = new TabixSearchPipe(tabixDataFile);
        this.comparableObject = new FilterLogic();
    }

    protected History copyAppend(History aHistory, String result) {
        History clone = (History)aHistory.clone();
        clone.add(result);
        return clone;
    }

    protected void setup(History history) {
        if (this.isFirst) {
            this.isFirst = false;
            if (this.historyPos > 0) {
                this.historyPos = this.historyPos - history.size() - 1;
            } else if (this.historyPos == 0) {
                throw new InvalidPipeInputException("Invalid Column input", (Pipe)this);
            }
        }
    }

    private boolean valid(History history, ComparableObjectInterface fl) {
        String result = (String)this.search.next();
        boolean isSame = fl.same((String)history.get(history.size() + this.historyPos), result);
        this.validResult = isSame ? result : "";
        return isSame;
    }

    public List<History> processHistory(History history) throws NoSuchElementException {
        ArrayList<History> results = new ArrayList<History>();
        this.setup(history);
        this.search.reset();
        this.search.setStarts(Arrays.asList((String)history.get(history.size() + this.historyPos)));
        while (this.search.hasNext()) {
            if (!this.valid(history, this.comparableObject)) continue;
            results.add(this.copyAppend(history, this.validResult));
        }
        if (results.isEmpty()) {
            results.add(this.copyAppend(history, kBlankJSON));
        }
        return results;
    }

    protected History processNextStart() throws NoSuchElementException {
        if (this.mResults.isEmpty()) {
            this.mResults = this.processHistory((History)this.starts.next());
        }
        return this.mResults.remove(0);
    }

    protected class FilterLogic
    implements ComparableObjectInterface {
        protected FilterLogic() {
        }

        @Override
        public boolean same(String a, String b) {
            return true;
        }
    }
}

