/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.NoSuchElementException;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class BgzipWriter
extends AbstractPipe<History, History> {
    private String mBgzipOutFilePath;
    private BlockCompressedOutputStream mBgzipOutStream;

    public BgzipWriter(String bgzipOutFilePath) {
        this.mBgzipOutFilePath = bgzipOutFilePath;
    }

    protected History processNextStart() throws NoSuchElementException {
        try {
            History nextLine = (History)this.starts.next();
            if (this.mBgzipOutStream == null) {
                this.mBgzipOutStream = new BlockCompressedOutputStream(this.mBgzipOutFilePath, 9);
            }
            this.mBgzipOutStream.write((this.merge(nextLine) + "\n").getBytes());
            return nextLine;
        }
        catch (NoSuchElementException noSuchExc) {
            try {
                this.mBgzipOutStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchElementException("Error closing the bgzip stream: " + e.getMessage());
            }
            throw new NoSuchElementException("No more data");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error writing to bgzip file");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException("Error creating tabix file");
        }
    }

    private String merge(History history) {
        StringBuilder strBuilder = new StringBuilder();
        for (String col : history) {
            strBuilder.append(col + "\t");
        }
        String str = strBuilder.toString();
        if (str.endsWith("\t")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

