/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.modify;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.inject.BaseInjector;
import edu.mayo.pipes.JSON.modify.JsonPathInfo;
import edu.mayo.pipes.JSON.modify.JsonTypeExtended;
import edu.mayo.pipes.JSON.modify.ModifyJsonConfig;
import edu.mayo.pipes.JSON.modify.ModifyJsonConfigException;
import edu.mayo.pipes.JSON.modify.ModifyJsonConfigLine;
import edu.mayo.pipes.JSON.modify.ModifyJsonOperation;
import edu.mayo.pipes.exceptions.InvalidJSONException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModifyJsonPipe
extends AbstractPipe<History, History> {
    protected static Logger sLogger = Logger.getLogger(ModifyJsonPipe.class);
    private static final String NULL = "(NULL)";
    private static final String REMOVE = "(REMOVE)";
    private static final String ADD = "(ADD)";
    private static final String ANY = "(ANY)";
    private File configFile;
    private List<ModifyJsonConfigLine> configLines = new ArrayList<ModifyJsonConfigLine>();
    private int jsonColumn = -1;
    private long lineNum = 0L;

    public ModifyJsonPipe(int jsonColumn, File configFile) throws IOException, ModifyJsonConfigException {
        this.configFile = configFile;
        this.jsonColumn = jsonColumn;
        ModifyJsonConfig modifyConfig = new ModifyJsonConfig();
        this.configLines = modifyConfig.parseConfigFile(this.configFile);
    }

    protected History processNextStart() throws NoSuchElementException, InvalidJSONException {
        History history = (History)this.starts.next();
        if (this.isHeaderLine(history)) {
            return history;
        }
        int jsonColNonNegative = this.getNonNegativeJsonColumn(this.jsonColumn, history);
        History historyOut = null;
        try {
            ++this.lineNum;
            historyOut = this.applyAllChanges(history, jsonColNonNegative);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = e.getMessage() + "\nLine #" + this.lineNum + " (data line #, not including headers):\n" + history.getMergedData("\t");
            throw new RuntimeException(msg);
        }
        return historyOut;
    }

    private boolean isHeaderLine(History history) {
        return history.size() > 0 && ((String)history.get(0)).startsWith("#");
    }

    private History applyAllChanges(History history, int jsonColNonNegative) throws JSONException, ModifyJsonConfigException {
        JSONObject jsonRootObj = new JSONObject((String)history.get(jsonColNonNegative));
        for (ModifyJsonConfigLine configLine : this.configLines) {
            this.applyChange(jsonRootObj, configLine);
        }
        history.set(jsonColNonNegative, jsonRootObj.toString());
        return history;
    }

    private void applyChange(JSONObject rootJsonObj, ModifyJsonConfigLine configLine) throws JSONException, ModifyJsonConfigException {
        JsonPathInfo jsonPathInfo = this.findJsonPathInfo(rootJsonObj, configLine.key);
        if (ModifyJsonOperation.MODIFY == configLine.operation && jsonPathInfo.isFound) {
            this.modifyJsonValue(configLine, jsonPathInfo);
        } else if (ModifyJsonOperation.ADD == configLine.operation) {
            this.addJsonValue(rootJsonObj, configLine);
        } else if (ModifyJsonOperation.REMOVE == configLine.operation && jsonPathInfo.isFound) {
            jsonPathInfo.parentJsonObject.remove(jsonPathInfo.childKey);
        }
    }

    private void modifyJsonValue(ModifyJsonConfigLine configLine, JsonPathInfo jsonPathInfo) throws JSONException, ModifyJsonConfigException {
        boolean isFromArray = jsonPathInfo.value instanceof JSONArray;
        boolean isStringToString = !isFromArray && !configLine.isToArray();
        boolean isStringToArray = !isFromArray && configLine.isToArray();
        boolean isArrayToString = isFromArray && !configLine.isToArray();
        boolean isArrayToArray = isFromArray && configLine.isToArray();
        Object valAfterReplacements = null;
        if (isStringToString) {
            valAfterReplacements = this.replaceSingleValue(this.toString(jsonPathInfo.value), configLine);
        } else if (isStringToArray) {
            String[] stringArray;
            if (this.isNull(jsonPathInfo.value)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = null;
            } else {
                stringArray = StringUtils.safeSplit(this.toString(jsonPathInfo.value), configLine.delim);
            }
            String[] vals = stringArray;
            List<String> valList = Arrays.asList(vals);
            valAfterReplacements = this.replaceArrayValues(valList, configLine);
        } else if (isArrayToString) {
            valAfterReplacements = this.replaceArrayValues(this.jsonArrayToList((JSONArray)jsonPathInfo.value), configLine);
            valAfterReplacements = this.arrayToString((ArrayList)valAfterReplacements, configLine.delim);
        } else if (isArrayToArray) {
            valAfterReplacements = this.replaceArrayValues(this.jsonArrayToList((JSONArray)jsonPathInfo.value), configLine);
        }
        this.setValue(valAfterReplacements, jsonPathInfo, configLine);
    }

    private void addJsonValue(JSONObject rootJsonObj, ModifyJsonConfigLine configLine) throws NumberFormatException, JSONException, ModifyJsonConfigException {
        JsonPathInfo jsonPathInfo = this.createParentJsonPathsAsNeeded(configLine.key, rootJsonObj);
        if (jsonPathInfo.parentJsonObject.has(jsonPathInfo.childKey)) {
            System.err.println("Key is already present and could not be added: " + configLine.key + "  to line:\n" + rootJsonObj.toString());
        }
        this.setValue(this.getFirstSetToValue(configLine), jsonPathInfo, configLine);
    }

    private JsonPathInfo createParentJsonPathsAsNeeded(String key, JSONObject rootJsonObj) throws JSONException {
        JsonPathInfo jsonPathInfo = new JsonPathInfo();
        jsonPathInfo.childKey = key;
        jsonPathInfo.fullPath = key;
        jsonPathInfo.isFound = true;
        jsonPathInfo.parentJsonObject = rootJsonObj;
        while (key.contains(".")) {
            String parentKey = key.substring(0, key.indexOf("."));
            jsonPathInfo.childKey = key = key.substring(key.indexOf(".") + 1);
            jsonPathInfo.nodeParents.add(parentKey);
            if (jsonPathInfo.parentJsonObject.has(parentKey)) {
                jsonPathInfo.parentJsonObject = jsonPathInfo.parentJsonObject.getJSONObject(parentKey);
                continue;
            }
            JSONObject jsonObj = new JSONObject();
            jsonPathInfo.parentJsonObject.put(parentKey, (Object)jsonObj);
            jsonPathInfo.parentJsonObject = jsonObj;
        }
        return jsonPathInfo;
    }

    private Object getFirstSetToValue(ModifyJsonConfigLine configLine) {
        Properties props = configLine.findAndReplace;
        Iterator<Object> iterator = props.keySet().iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            return props.get(key);
        }
        return null;
    }

    private String toString(Object jsonElem) {
        if (this.isNull(jsonElem)) {
            return null;
        }
        return jsonElem.toString().trim();
    }

    private boolean isNull(Object obj) {
        return obj == null || JSONObject.NULL.equals(obj) || obj instanceof String && NULL.equals(obj);
    }

    private boolean isToArray(ModifyJsonConfigLine configLine) throws ModifyJsonConfigException {
        return configLine.count.equals(".") || this.isInt(configLine.count) && this.toInt(configLine.count) > 1;
    }

    private void setValue(Object val, JsonPathInfo jsonPathInfo, ModifyJsonConfigLine configLine) throws JSONException, NumberFormatException, ModifyJsonConfigException {
        boolean isToArray = this.isToArray(configLine);
        String valStr = this.toString(val);
        boolean isBooleanObj = JsonTypeExtended.BOOLEAN.equals((Object)configLine.newType);
        if (isBooleanObj) {
            if (isToArray) {
                jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, (Object)this.toJsonArrayBoolean(val));
            } else {
                Boolean bool = BaseInjector.toBoolean(valStr);
                if (bool == null) {
                    jsonPathInfo.parentJsonObject.remove(jsonPathInfo.childKey);
                } else {
                    jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, (Object)bool);
                }
            }
        } else if (this.isNull(val)) {
            jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, JSONObject.NULL);
        } else if (valStr.length() == 0 || REMOVE.equals(valStr)) {
            jsonPathInfo.parentJsonObject.remove(jsonPathInfo.childKey);
        } else if (JsonTypeExtended.INTEGER.equals((Object)configLine.newType)) {
            jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, isToArray ? this.toJsonArrayInteger(val) : this.toInt(valStr));
        } else if (JsonTypeExtended.FLOAT.equals((Object)configLine.newType)) {
            jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, isToArray ? this.toJsonArrayFloat(val) : (this.isInt(valStr) ? (Number)this.toInt(valStr) : (Number)this.toDouble(valStr)));
        } else {
            jsonPathInfo.parentJsonObject.put(jsonPathInfo.childKey, isToArray ? this.toJsonArrayString(val) : valStr);
        }
    }

    private String arrayToString(ArrayList<String> valList, String delim) {
        StringBuilder str = new StringBuilder();
        for (String val : valList) {
            if (str.length() > 0) {
                str.append(delim);
            }
            str.append(val);
        }
        return str.toString();
    }

    private JSONArray toJsonArrayString(Object valList) {
        JSONArray jsonArray = new JSONArray();
        for (String val : (List)valList) {
            jsonArray.put((Object)val);
        }
        return jsonArray;
    }

    private JSONArray toJsonArrayInteger(Object valList) throws NumberFormatException, JSONException, ModifyJsonConfigException {
        JSONArray jsonArray = new JSONArray();
        for (String val : (List)valList) {
            jsonArray.put((Object)this.toInt(val));
        }
        return jsonArray;
    }

    private JSONArray toJsonArrayFloat(Object valList) throws NumberFormatException, JSONException, ModifyJsonConfigException {
        JSONArray jsonArray = new JSONArray();
        for (String val : (List)valList) {
            jsonArray.put((Object)(this.isInt(val) ? (Number)this.toInt(val) : (Number)this.toDouble(val)));
        }
        return jsonArray;
    }

    private JSONArray toJsonArrayBoolean(Object valList) {
        JSONArray jsonArray = new JSONArray();
        for (String val : (List)valList) {
            jsonArray.put((Object)BaseInjector.toBoolean(val));
        }
        return jsonArray;
    }

    private List<String> jsonArrayToList(JSONArray jsonArray) {
        ArrayList<String> valList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            valList.add(jsonArray.get(i).toString());
        }
        return valList;
    }

    private Integer toInt(String val) throws ModifyJsonConfigException {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new ModifyJsonConfigException("Could not convert value to Integer: " + val);
        }
    }

    private Number toDouble(String val) throws ModifyJsonConfigException {
        try {
            Double d = Double.parseDouble(val);
            if (d.toString().equals(val)) {
                return d;
            }
            return new BigDecimal(val);
        }
        catch (Exception e) {
            throw new ModifyJsonConfigException("Could not convert value to Float: " + val);
        }
    }

    private Object replaceArrayValues(List<String> valList, ModifyJsonConfigLine configLine) throws JSONException, ModifyJsonConfigException {
        ArrayList<String> vals = new ArrayList<String>();
        for (int i = 0; i < valList.size(); ++i) {
            String val = this.toString(valList.get(i));
            String valAfterReplacements = (String)this.replaceSingleValue(val, configLine);
            if (this.isNull(valAfterReplacements)) {
                vals.add(null);
                continue;
            }
            if (REMOVE.equals(valAfterReplacements)) continue;
            if (valAfterReplacements.contains(configLine.delim) && valList.size() > 1) {
                String errMsg = "JSON Array data for key '" + configLine.key + "' cannot contain the delimiter (delimiter=" + configLine.delim + ")";
                throw new ModifyJsonConfigException(errMsg);
            }
            vals.add(valAfterReplacements);
        }
        return vals;
    }

    private Object replaceSingleValue(String str, ModifyJsonConfigLine configLine) {
        for (Object find : configLine.findAndReplace.keySet()) {
            boolean isBothNull;
            boolean bl = isBothNull = this.isNull(str) && this.isNull(find);
            if (!isBothNull && !((String)find).equalsIgnoreCase(str)) continue;
            String val = configLine.findAndReplace.getProperty((String)find);
            return val;
        }
        return str;
    }

    private boolean isInt(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private JsonPathInfo findJsonPathInfo(JSONObject jsonRootObj, String fullPathKey) throws JSONException {
        JsonPathInfo jsonPathInfo = new JsonPathInfo();
        JSONObject jsonObj = jsonRootObj;
        String childKey = fullPathKey;
        while (!jsonPathInfo.isFound && !this.isNull(jsonObj)) {
            if (jsonObj.has(childKey)) {
                jsonPathInfo.fullPath = fullPathKey;
                jsonPathInfo.isFound = true;
                jsonPathInfo.childKey = childKey;
                jsonPathInfo.parentJsonObject = jsonObj;
                jsonPathInfo.value = jsonObj.get(childKey);
                continue;
            }
            if (childKey.contains(".")) {
                String parentKey = childKey.substring(0, childKey.indexOf("."));
                childKey = childKey.substring(childKey.indexOf(".") + 1);
                if (jsonObj.has(parentKey)) {
                    jsonObj = jsonObj.getJSONObject(parentKey);
                    jsonPathInfo.nodeParents.add(parentKey);
                    continue;
                }
                jsonObj = null;
                continue;
            }
            jsonObj = null;
        }
        return jsonPathInfo;
    }

    private int getNonNegativeJsonColumn(int jsonCol, History history) {
        if (jsonCol < 0) {
            return history.size() + jsonCol;
        }
        return jsonCol - 1;
    }
}

