/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Fmath {
    public static final double N_AVAGADRO = 6.0221419947E23;
    public static final double K_BOLTZMANN = 1.380650324E-23;
    public static final double H_PLANCK = 6.6260687652E-34;
    public static final double H_PLANCK_RED = 1.0545715972483913E-34;
    public static final double C_LIGHT = 2.99792458E8;
    public static final double R_GAS = 8.31447215;
    public static final double F_FARADAY = 96485.341539;
    public static final double T_ABS = -273.15;
    public static final double Q_ELECTRON = -1.60217646263E-19;
    public static final double M_ELECTRON = 9.1093818872E-31;
    public static final double M_PROTON = 1.6726215813E-27;
    public static final double M_NEUTRON = 1.6749271613E-27;
    public static final double EPSILON_0 = 8.854187817E-12;
    public static final double MU_0 = 1.2566370614359173E-6;
    public static final double ETA_0 = 376.73031346177066;
    public static final double EULER_CONSTANT_GAMMA = 0.5772156649015627;
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    private static final Map<Object, Object> integers = new HashMap<Object, Object>();

    public static double log10(double a) {
        return Math.log(a) / Math.log(10.0);
    }

    public static float log10(float a) {
        return (float)(Math.log(a) / Math.log(10.0));
    }

    public static double antilog10(double x) {
        return Math.pow(10.0, x);
    }

    public static float antilog10(float x) {
        return (float)Math.pow(10.0, x);
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static float log(float a) {
        return (float)Math.log(a);
    }

    public static double antilog(double x) {
        return Math.exp(x);
    }

    public static float antilog(float x) {
        return (float)Math.exp(x);
    }

    public static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    public static float log2(float a) {
        return (float)(Math.log(a) / Math.log(2.0));
    }

    public static double antilog2(double x) {
        return Math.pow(2.0, x);
    }

    public static float antilog2(float x) {
        return (float)Math.pow(2.0, x);
    }

    public static double log10(double a, double b) {
        return Math.log(a) / Math.log(b);
    }

    public static double log10(double a, int b) {
        return Math.log(a) / Math.log(b);
    }

    public static float log10(float a, float b) {
        return (float)(Math.log(a) / Math.log(b));
    }

    public static float log10(float a, int b) {
        return (float)(Math.log(a) / Math.log(b));
    }

    public static double square(double a) {
        return a * a;
    }

    public static float square(float a) {
        return a * a;
    }

    public static BigDecimal square(BigDecimal a) {
        return a.multiply(a);
    }

    public static int square(int a) {
        return a * a;
    }

    public static long square(long a) {
        return a * a;
    }

    public static BigInteger square(BigInteger a) {
        return a.multiply(a);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int f = 1;
        for (int i = 2; i <= n; ++i) {
            f *= i;
        }
        return f;
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long f = 1L;
        for (long iCount = 2L; iCount <= n; ++iCount) {
            f *= iCount;
        }
        return f;
    }

    public static BigInteger factorial(BigInteger n) {
        BigInteger one;
        if (n.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigInteger f = one = BigInteger.ONE;
        BigInteger iCount = new BigInteger("2");
        while (iCount.compareTo(n) != 1) {
            f = f.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f;
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 1.0;
        for (double iCount = 2.0; iCount <= n; iCount += 1.0) {
            f *= iCount;
        }
        return f;
    }

    public static BigDecimal factorial(BigDecimal n) {
        BigDecimal one;
        if (n.compareTo(BigDecimal.ZERO) == -1 || !Fmath.isInteger(n)) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigDecimal f = one = BigDecimal.ONE;
        BigDecimal iCount = new BigDecimal(2.0);
        while (iCount.compareTo(n) != 1) {
            f = f.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (int i = 2; i <= n; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double logFactorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (long iCount = 2L; iCount <= n; ++iCount) {
            f += Math.log(iCount);
        }
        return f;
    }

    public static double logFactorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (double iCount = 2.0; iCount <= n; iCount += 1.0) {
            f += Math.log(iCount);
        }
        return f;
    }

    public static double sign(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static float sign(float x) {
        if (x < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static int sign(int x) {
        if (x < 0) {
            return -1;
        }
        return 1;
    }

    public static long sign(long x) {
        if (x < 0L) {
            return -1L;
        }
        return 1L;
    }

    public static double hypot(double aa, double bb) {
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public static float hypot(float aa, float bb) {
        return (float)Fmath.hypot((double)aa, (double)bb);
    }

    public static double angle(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double ccos = Fmath.cos(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.acos(ccos);
    }

    public static double angle(double sideAC, double sideBC, double sideAB) {
        double ccos = Fmath.cos(sideAC, sideBC, sideAB);
        return Math.acos(ccos);
    }

    public static double sin(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.sin(angle);
    }

    public static double sin(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.sin(angle);
    }

    public static double sin(double arg) {
        return Math.sin(arg);
    }

    public static double asin(double a) {
        if (a < -1.0 && a > 1.0) {
            throw new IllegalArgumentException("Fmath.asin argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.asin(a);
    }

    public static double cos(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double sideAC = Fmath.hypot(xAtA - xAtC, yAtA - yAtC);
        double sideBC = Fmath.hypot(xAtB - xAtC, yAtB - yAtC);
        double sideAB = Fmath.hypot(xAtA - xAtB, yAtA - yAtB);
        return Fmath.cos(sideAC, sideBC, sideAB);
    }

    public static double cos(double sideAC, double sideBC, double sideAB) {
        return 0.5 * (sideAC / sideBC + sideBC / sideAC - sideAB / sideAC * (sideAB / sideBC));
    }

    public static double cos(double arg) {
        return Math.cos(arg);
    }

    public static double acos(double a) {
        if (a < -1.0 || a > 1.0) {
            throw new IllegalArgumentException("Fmath.acos argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.acos(a);
    }

    public static double tan(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.tan(angle);
    }

    public static double tan(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.tan(angle);
    }

    public static double tan(double arg) {
        return Math.tan(arg);
    }

    public static double atan(double a) {
        return Math.atan(a);
    }

    public static double atan2(double a, double b) {
        return Math.atan2(a, b);
    }

    public static double cot(double a) {
        return 1.0 / Math.tan(a);
    }

    public static double acot(double a) {
        return Math.atan(1.0 / a);
    }

    public static double acot2(double a, double b) {
        return Math.atan2(b, a);
    }

    public static double sec(double a) {
        return 1.0 / Math.cos(a);
    }

    public static double asec(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("asec argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.acos(1.0 / a);
    }

    public static double csc(double a) {
        return 1.0 / Math.sin(a);
    }

    public static double acsc(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("acsc argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.asin(1.0 / a);
    }

    public static double exsec(double a) {
        return 1.0 / Math.cos(a) - 1.0;
    }

    public static double aexsec(double a) {
        if (a < 0.0 && a > -2.0) {
            throw new IllegalArgumentException("aexsec argument (" + a + ") must be >= 0.0 and <= -2");
        }
        return Math.asin(1.0 / (1.0 + a));
    }

    public static double vers(double a) {
        return 1.0 - Math.cos(a);
    }

    public static double avers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("avers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.acos(1.0 - a);
    }

    public static double covers(double a) {
        return 1.0 - Math.sin(a);
    }

    public static double acovers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("acovers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.asin(1.0 - a);
    }

    public static double hav(double a) {
        return 0.5 * Fmath.vers(a);
    }

    public static double ahav(double a) {
        if (a < 0.0 && a > 1.0) {
            throw new IllegalArgumentException("ahav argument (" + a + ") must be >= 0 and <= 1");
        }
        return Fmath.acos(1.0 - 2.0 * a);
    }

    public static double sinc(double a) {
        if (Math.abs(a) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(a) / a;
    }

    public static double nsinc(double a) {
        if (Math.abs(a) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(Math.PI * a) / (Math.PI * a);
    }

    public static double sinh(double a) {
        return 0.5 * (Math.exp(a) - Math.exp(-a));
    }

    public static double asinh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return sgn * Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public static double cosh(double a) {
        return 0.5 * (Math.exp(a) + Math.exp(-a));
    }

    public static double acosh(double a) {
        if (a < 1.0) {
            throw new IllegalArgumentException("acosh real number argument (" + a + ") must be >= 1");
        }
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static double tanh(double a) {
        return Fmath.sinh(a) / Fmath.cosh(a);
    }

    public static double atanh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a > 1.0) {
            throw new IllegalArgumentException("atanh real number argument (" + sgn * a + ") must be >= -1 and <= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(1.0 - a));
    }

    public static double coth(double a) {
        return 1.0 / Fmath.tanh(a);
    }

    public static double acoth(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a < 1.0) {
            throw new IllegalArgumentException("acoth real number argument (" + sgn * a + ") must be <= -1 or >= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(a - 1.0));
    }

    public static double sech(double a) {
        return 1.0 / Fmath.cosh(a);
    }

    public static double asech(double a) {
        if (a > 1.0 || a < 0.0) {
            throw new IllegalArgumentException("asech real number argument (" + a + ") must be >= 0 and <= 1");
        }
        return 0.5 * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) - 1.0));
    }

    public static double csch(double a) {
        return 1.0 / Fmath.sinh(a);
    }

    public static double acsch(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return 0.5 * sgn * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) + 1.0));
    }

    public static int checkPrecision(double number) {
        boolean test = true;
        int prec = 0;
        if (Fmath.isNaN(number)) {
            test = false;
        }
        if (Fmath.isPlusInfinity(number)) {
            test = false;
        }
        if (Fmath.isMinusInfinity(number)) {
            test = false;
        }
        while (test) {
            if (number == Fmath.truncate(number, prec)) {
                test = false;
                continue;
            }
            if (++prec <= 20) continue;
            test = false;
        }
        return prec;
    }

    public static int checkPrecision(float number) {
        return Fmath.checkPrecision((double)number);
    }

    public static double truncate(double xDouble, int trunc) {
        double xTruncated = xDouble;
        if (!(Fmath.isNaN(xDouble) || Fmath.isPlusInfinity(xDouble) || Fmath.isMinusInfinity(xDouble) || xDouble == 0.0)) {
            String xString = new Double(xDouble).toString().trim();
            xTruncated = Double.parseDouble(Fmath.truncateProcedure(xString, trunc));
        }
        return xTruncated;
    }

    public static float truncate(float xFloat, int trunc) {
        float xTruncated = xFloat;
        if (!(Fmath.isNaN(xFloat) || Fmath.isPlusInfinity(xFloat) || Fmath.isMinusInfinity(xFloat) || (double)xFloat == 0.0)) {
            String xString = new Float(xFloat).toString().trim();
            xTruncated = Float.parseFloat(Fmath.truncateProcedure(xString, trunc));
        }
        return xTruncated;
    }

    private static String truncateProcedure(String xValue, int trunc) {
        String xTruncated = xValue;
        String xWorking = xValue;
        String exponent = " ";
        String first = "+";
        int expPos = xValue.indexOf(69);
        int dotPos = xValue.indexOf(46);
        int minPos = xValue.indexOf(45);
        if (minPos != -1 && minPos == 0) {
            xWorking = xWorking.substring(1);
            first = "-";
            --dotPos;
            --expPos;
        }
        if (expPos > -1) {
            exponent = xWorking.substring(expPos);
            xWorking = xWorking.substring(0, expPos);
        }
        String xPreDot = null;
        String xPostDot = "0";
        String xDiscarded = null;
        String tempString = null;
        double tempDouble = 0.0;
        if (dotPos > -1) {
            xPreDot = xWorking.substring(0, dotPos);
            xPostDot = xWorking.substring(dotPos + 1);
            int xLength = xPostDot.length();
            if (trunc < xLength) {
                xDiscarded = xPostDot.substring(trunc);
                tempString = xDiscarded.substring(0, 1) + ".";
                tempString = xDiscarded.length() > 1 ? tempString + xDiscarded.substring(1) : tempString + "0";
                tempDouble = Math.round(Double.parseDouble(tempString));
                if (trunc > 0) {
                    if (tempDouble >= 5.0) {
                        int[] xArray = new int[trunc + 1];
                        xArray[0] = 0;
                        for (int i = 0; i < trunc; ++i) {
                            xArray[i + 1] = Integer.parseInt(xPostDot.substring(i, i + 1));
                        }
                        boolean test = true;
                        int iCounter = trunc;
                        while (test) {
                            int n = iCounter;
                            xArray[n] = xArray[n] + 1;
                            if (iCounter > 0) {
                                if (xArray[iCounter] < 10) {
                                    test = false;
                                    continue;
                                }
                                xArray[iCounter] = 0;
                                --iCounter;
                                continue;
                            }
                            test = false;
                        }
                        int preInt = Integer.parseInt(xPreDot);
                        xPreDot = new Integer(preInt += xArray[0]).toString();
                        tempString = "";
                        for (int i = 1; i <= trunc; ++i) {
                            tempString = tempString + new Integer(xArray[i]).toString();
                        }
                        xPostDot = tempString;
                    } else {
                        xPostDot = xPostDot.substring(0, trunc);
                    }
                } else {
                    if (tempDouble >= 5.0) {
                        int preInt = Integer.parseInt(xPreDot);
                        xPreDot = new Integer(++preInt).toString();
                    }
                    xPostDot = "0";
                }
            }
            xTruncated = first + xPreDot.trim() + "." + xPostDot.trim() + exponent;
        }
        return xTruncated.trim();
    }

    public static boolean isInfinity(double x) {
        boolean test = false;
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isInfinity(float x) {
        boolean test = false;
        if (x == Float.POSITIVE_INFINITY || x == Float.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isPlusInfinity(double x) {
        boolean test = false;
        if (x == Double.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isPlusInfinity(float x) {
        boolean test = false;
        if (x == Float.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isMinusInfinity(double x) {
        boolean test = false;
        if (x == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isMinusInfinity(float x) {
        boolean test = false;
        if (x == Float.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public static boolean isNaN(double x) {
        boolean test = false;
        if (x != x) {
            test = true;
        }
        return test;
    }

    public static boolean isNaN(float x) {
        boolean test = false;
        if (x != x) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(double x, double y) {
        boolean test = false;
        if (Fmath.isNaN(x)) {
            if (Fmath.isNaN(y)) {
                test = true;
            }
        } else if (Fmath.isPlusInfinity(x)) {
            if (Fmath.isPlusInfinity(y)) {
                test = true;
            }
        } else if (Fmath.isMinusInfinity(x)) {
            if (Fmath.isMinusInfinity(y)) {
                test = true;
            }
        } else if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(float x, float y) {
        boolean test = false;
        if (Fmath.isNaN(x)) {
            if (Fmath.isNaN(y)) {
                test = true;
            }
        } else if (Fmath.isPlusInfinity(x)) {
            if (Fmath.isPlusInfinity(y)) {
                test = true;
            }
        } else if (Fmath.isMinusInfinity(x)) {
            if (Fmath.isMinusInfinity(y)) {
                test = true;
            }
        } else if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(int x, int y) {
        boolean test = false;
        if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(char x, char y) {
        boolean test = false;
        if (x == y) {
            test = true;
        }
        return test;
    }

    public static boolean isEqual(String x, String y) {
        boolean test = false;
        if (x.equals(y)) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(double x, double y, double limit) {
        boolean test = false;
        if (Math.abs(x - y) <= Math.abs(limit)) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(float x, float y, float limit) {
        boolean test = false;
        if (Math.abs(x - y) <= Math.abs(limit)) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(long x, long y, long limit) {
        boolean test = false;
        if (Math.abs(x - y) <= Math.abs(limit)) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(int x, int y, int limit) {
        boolean test = false;
        if (Math.abs(x - y) <= Math.abs(limit)) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(BigDecimal x, BigDecimal y, BigDecimal limit) {
        boolean test = false;
        if (x.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinLimits(BigInteger x, BigInteger y, BigInteger limit) {
        boolean test = false;
        if (x.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(double x, double y, double perCent) {
        boolean test = false;
        double limit = Math.abs((x + y) * perCent / 200.0);
        if (Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(float x, float y, float perCent) {
        boolean test = false;
        double limit = Math.abs((x + y) * perCent / 200.0f);
        if ((double)Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(long x, long y, double perCent) {
        boolean test = false;
        double limit = Math.abs((double)(x + y) * perCent / 200.0);
        if ((double)Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(long x, long y, long perCent) {
        boolean test = false;
        double limit = Math.abs((double)(x + y) * (double)perCent / 200.0);
        if ((double)Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(int x, int y, double perCent) {
        boolean test = false;
        double limit = Math.abs((double)(x + y) * perCent / 200.0);
        if ((double)Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(int x, int y, int perCent) {
        boolean test = false;
        double limit = Math.abs((double)(x + y) * (double)perCent / 200.0);
        if ((double)Math.abs(x - y) <= limit) {
            test = true;
        }
        return test;
    }

    public static boolean isEqualWithinPerCent(BigDecimal x, BigDecimal y, BigDecimal perCent) {
        boolean test = false;
        BigDecimal limit = x.add(y).multiply(perCent).multiply(new BigDecimal("0.005"));
        if (x.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test = true;
        }
        limit = null;
        return test;
    }

    public static boolean isEqualWithinPerCent(BigInteger x, BigInteger y, BigDecimal perCent) {
        boolean test = false;
        BigDecimal xx = new BigDecimal(x);
        BigDecimal yy = new BigDecimal(y);
        BigDecimal limit = xx.add(yy).multiply(perCent).multiply(new BigDecimal("0.005"));
        if (xx.subtract(yy).abs().compareTo(limit.abs()) <= 0) {
            test = true;
        }
        limit = null;
        xx = null;
        yy = null;
        return test;
    }

    public static boolean isEqualWithinPerCent(BigInteger x, BigInteger y, BigInteger perCent) {
        boolean test = false;
        BigDecimal xx = new BigDecimal(x);
        BigDecimal yy = new BigDecimal(y);
        BigDecimal pc = new BigDecimal(perCent);
        BigDecimal limit = xx.add(yy).multiply(pc).multiply(new BigDecimal("0.005"));
        if (xx.subtract(yy).abs().compareTo(limit.abs()) <= 0) {
            test = true;
        }
        limit = null;
        xx = null;
        yy = null;
        pc = null;
        return test;
    }

    public static int compare(double x, double y) {
        Double X = new Double(x);
        Double Y = new Double(y);
        return X.compareTo(Y);
    }

    public static int compare(int x, int y) {
        Integer X = new Integer(x);
        Integer Y = new Integer(y);
        return X.compareTo(Y);
    }

    public static int compare(long x, long y) {
        Long X = new Long(x);
        Long Y = new Long(y);
        return X.compareTo(Y);
    }

    public static int compare(float x, float y) {
        Float X = new Float(x);
        Float Y = new Float(y);
        return X.compareTo(Y);
    }

    public static int compare(byte x, byte y) {
        Byte X = new Byte(x);
        Byte Y = new Byte(y);
        return X.compareTo(Y);
    }

    public static int compare(short x, short y) {
        Short X = new Short(x);
        Short Y = new Short(y);
        return X.compareTo(Y);
    }

    public static boolean compare(double[] array1, double[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (array1[i] == array2[i]) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean compare(float[] array1, float[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (array1[i] == array2[i]) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean compare(int[] array1, int[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (array1[i] == array2[i]) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean compare(long[] array1, long[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (array1[i] == array2[i]) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean isInteger(double x) {
        boolean retn = false;
        double xfloor = Math.floor(x);
        if (x - xfloor == 0.0) {
            retn = true;
        }
        return retn;
    }

    public static boolean isInteger(double[] x) {
        boolean retn = true;
        boolean test = true;
        int ii = 0;
        while (test) {
            double xfloor = Math.floor(x[ii]);
            if (x[ii] - xfloor != 0.0) {
                retn = false;
                test = false;
                continue;
            }
            if (++ii != x.length) continue;
            test = false;
        }
        return retn;
    }

    public static boolean isInteger(float x) {
        boolean ret = false;
        float xfloor = (float)Math.floor(x);
        if (x - xfloor == 0.0f) {
            ret = true;
        }
        return ret;
    }

    public static boolean isInteger(float[] x) {
        boolean retn = true;
        boolean test = true;
        int ii = 0;
        while (test) {
            float xfloor = (float)Math.floor(x[ii]);
            if ((double)(x[ii] - xfloor) != 0.0) {
                retn = false;
                test = false;
                continue;
            }
            if (++ii != x.length) continue;
            test = false;
        }
        return retn;
    }

    public static boolean isInteger(Number numberAsObject) {
        boolean test = integers.containsKey(numberAsObject.getClass());
        if (!test) {
            double dd;
            if (numberAsObject instanceof Double) {
                dd = numberAsObject.doubleValue();
                test = Fmath.isInteger(dd);
            }
            if (numberAsObject instanceof Float) {
                float dd2 = numberAsObject.floatValue();
                test = Fmath.isInteger(dd2);
            }
            if (numberAsObject instanceof BigDecimal) {
                dd = numberAsObject.doubleValue();
                test = Fmath.isInteger(dd);
            }
        }
        return test;
    }

    public static boolean isInteger(Number[] numberAsObject) {
        boolean testall = true;
        for (int i = 0; i < numberAsObject.length; ++i) {
            double dd;
            boolean test = integers.containsKey(numberAsObject[i].getClass());
            if (test) continue;
            if (numberAsObject[i] instanceof Double && !(test = Fmath.isInteger(dd = numberAsObject[i].doubleValue()))) {
                testall = false;
            }
            if (numberAsObject[i] instanceof Float && !(test = Fmath.isInteger(dd = numberAsObject[i].floatValue()))) {
                testall = false;
            }
            if (!(numberAsObject[i] instanceof BigDecimal) || (test = Fmath.isInteger(dd = numberAsObject[i].doubleValue()))) continue;
            testall = false;
        }
        return testall;
    }

    public static boolean isEven(int x) {
        boolean test = false;
        if ((double)(x % 2) == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isEven(float x) {
        double y = Math.floor(x);
        if ((double)x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = false;
        y = Math.floor(x / 2.0f);
        if ((double)(x / 2.0f) - y == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isEven(double x) {
        double y = Math.floor(x);
        if (x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = false;
        y = Math.floor(x / 2.0);
        if (x / 2.0 - y == 0.0) {
            test = true;
        }
        return test;
    }

    public static boolean isOdd(int x) {
        boolean test = true;
        if ((double)(x % 2) == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean isOdd(float x) {
        double y = Math.floor(x);
        if ((double)x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = true;
        y = Math.floor(x / 2.0f);
        if ((double)(x / 2.0f) - y == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean isOdd(double x) {
        double y = Math.floor(x);
        if (x - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test = true;
        y = Math.floor(x / 2.0);
        if (x / 2.0 - y == 0.0) {
            test = false;
        }
        return test;
    }

    public static boolean leapYear(int year) {
        boolean test = false;
        test = year % 4 != 0 ? false : (year % 400 == 0 ? true : year % 100 != 0);
        return test;
    }

    public static long dateToJavaMilliS(int year, int month, int day, int hour, int min, int sec) {
        long[] monthDays = new long[]{0L, 31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
        long ms = 0L;
        long yearDiff = 0L;
        for (int yearTest = year - 1; yearTest >= 1970; --yearTest) {
            yearDiff += 365L;
            if (!Fmath.leapYear(yearTest)) continue;
            ++yearDiff;
        }
        yearDiff *= 86400000L;
        long monthDiff = 0L;
        for (int monthTest = month - 1; monthTest > 0; --monthTest) {
            monthDiff += monthDays[monthTest];
            if (!Fmath.leapYear(year)) continue;
            ++monthDiff;
        }
        ms = yearDiff + (monthDiff *= 86400000L) + (long)day * 24L * 60L * 60L * 1000L + (long)hour * 60L * 60L * 1000L + (long)min * 60L * 1000L + (long)sec * 1000L;
        return ms;
    }

    public static double maximum(double[] aa) {
        int n = aa.length;
        double aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] > aamax)) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static float maximum(float[] aa) {
        int n = aa.length;
        float aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] > aamax)) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static int maximum(int[] aa) {
        int n = aa.length;
        int aamax = aa[0];
        for (int i = 1; i < n; ++i) {
            if (aa[i] <= aamax) continue;
            aamax = aa[i];
        }
        return aamax;
    }

    public static long maximum(long[] aa) {
        long n = aa.length;
        long aamax = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static double minimum(double[] aa) {
        int n = aa.length;
        double aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] < aamin)) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static float minimum(float[] aa) {
        int n = aa.length;
        float aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (!(aa[i] < aamin)) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static int minimum(int[] aa) {
        int n = aa.length;
        int aamin = aa[0];
        for (int i = 1; i < n; ++i) {
            if (aa[i] >= aamin) continue;
            aamin = aa[i];
        }
        return aamin;
    }

    public static long minimum(long[] aa) {
        long n = aa.length;
        long aamin = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static double maximumDifference(double[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static float maximumDifference(float[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static long maximumDifference(long[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static int maximumDifference(int[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static double minimumDifference(double[] aa) {
        double diff;
        double[] sorted = Fmath.selectionSort(aa);
        double n = aa.length;
        double minDiff = diff = sorted[1] - sorted[0];
        int i = 1;
        while ((double)i < n - 1.0) {
            diff = sorted[i + 1] - sorted[i];
            if (diff < minDiff) {
                minDiff = diff;
            }
            ++i;
        }
        return minDiff;
    }

    public static float minimumDifference(float[] aa) {
        float diff;
        float[] sorted = Fmath.selectionSort(aa);
        float n = aa.length;
        float minDiff = diff = sorted[1] - sorted[0];
        int i = 1;
        while ((float)i < n - 1.0f) {
            diff = sorted[i + 1] - sorted[i];
            if (diff < minDiff) {
                minDiff = diff;
            }
            ++i;
        }
        return minDiff;
    }

    public static long minimumDifference(long[] aa) {
        long diff;
        long[] sorted = Fmath.selectionSort(aa);
        long n = aa.length;
        long minDiff = diff = sorted[1] - sorted[0];
        int i = 1;
        while ((long)i < n - 1L) {
            diff = sorted[i + 1] - sorted[i];
            if (diff < minDiff) {
                minDiff = diff;
            }
            ++i;
        }
        return minDiff;
    }

    public static int minimumDifference(int[] aa) {
        int diff;
        int[] sorted = Fmath.selectionSort(aa);
        int n = aa.length;
        int minDiff = diff = sorted[1] - sorted[0];
        for (int i = 1; i < n - 1; ++i) {
            diff = sorted[i + 1] - sorted[i];
            if (diff >= minDiff) continue;
            minDiff = diff;
        }
        return minDiff;
    }

    public static double[] reverseArray(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static float[] reverseArray(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static int[] reverseArray(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static long[] reverseArray(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static char[] reverseArray(char[] aa) {
        int n = aa.length;
        char[] bb = new char[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[n - 1 - i];
        }
        return bb;
    }

    public static double[] arrayAbs(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static float[] arrayAbs(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static long[] arrayAbs(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static int[] arrayAbs(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.abs(aa[i]);
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (double)aa[i] * constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * (double)constant;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i] * constant;
        }
        return bb;
    }

    public static double[] log10Elements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.log10(aa[i]);
        }
        return bb;
    }

    public static float[] log10Elements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (float)Math.log10(aa[i]);
        }
        return bb;
    }

    public static double[] lnElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.log10(aa[i]);
        }
        return bb;
    }

    public static float[] lnElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (float)Math.log10(aa[i]);
        }
        return bb;
    }

    public static double[] squareRootElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.sqrt(aa[i]);
        }
        return bb;
    }

    public static float[] squareRootElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (float)Math.sqrt(aa[i]);
        }
        return bb;
    }

    public static double[] raiseElementsToPower(double[] aa, double power) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.pow(aa[i], power);
        }
        return bb;
    }

    public static double[] raiseElementsToPower(double[] aa, int power) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = Math.pow(aa[i], power);
        }
        return bb;
    }

    public static float[] raiseElementsToPower(float[] aa, float power) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (float)Math.pow(aa[i], power);
        }
        return bb;
    }

    public static float[] raiseElementsToPower(float[] aa, int power) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (float)Math.pow(aa[i], power);
        }
        return bb;
    }

    public static double[] invertElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = 1.0 / aa[i];
        }
        return bb;
    }

    public static float[] invertElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = 1.0f / aa[i];
        }
        return bb;
    }

    public static int[] indicesOf(double[] array, double value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(float[] array, float value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(long[] array, long value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(int[] array, int value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(short[] array, short value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(byte[] array, byte value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(char[] array, char value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(String[] array, String value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int[] indicesOf(Object[] array, Object value) {
        int i;
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        for (i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            ++numberOfIndices;
            arrayl.add(new Integer(i));
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            for (i = 0; i < numberOfIndices; ++i) {
                indices[i] = (Integer)arrayl.get(i);
            }
        }
        return indices;
    }

    public static int indexOf(double[] array, double value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(float[] array, float value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(long[] array, long value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(int[] array, int value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(byte[] array, byte value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(short[] array, short value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(char[] array, char value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter] == value) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(String[] array, String value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter].equals(value)) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static int indexOf(Object[] array, Object value) {
        int index = -1;
        boolean test = true;
        int counter = 0;
        while (test) {
            if (array[counter].equals(value)) {
                index = counter;
                test = false;
                continue;
            }
            if (++counter < array.length) continue;
            test = false;
        }
        return index;
    }

    public static double nearestElementValue(double[] array, double value) {
        double diff = Math.abs(array[0] - value);
        double nearest = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(Math.abs(array[i] - value) < diff)) continue;
            diff = Math.abs(array[i] - value);
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestElementIndex(double[] array, double value) {
        double diff = Math.abs(array[0] - value);
        int nearest = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(Math.abs(array[i] - value) < diff)) continue;
            diff = Math.abs(array[i] - value);
            nearest = i;
        }
        return nearest;
    }

    public static double nearestLowerElementValue(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test = true;
        double min = array[0];
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
            }
            if (value - array[ii] >= 0.0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        double min = array[0];
        int minI = 0;
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
                minI = ii;
            }
            if (value - array[ii] >= 0.0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static double nearestHigherElementValue(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test = true;
        double max = array[0];
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
            }
            if (array[ii] - value >= 0.0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(double[] array, double value) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        double max = array[0];
        int maxI = 0;
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
                maxI = ii;
            }
            if (array[ii] - value >= 0.0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (!(diff1 >= 0.0) || !(diff1 < diff0)) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static int nearestElementValue(int[] array, int value) {
        int diff = Math.abs(array[0] - value);
        int nearest = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Math.abs(array[i] - value) >= diff) continue;
            diff = Math.abs(array[i] - value);
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestElementIndex(int[] array, int value) {
        int diff = Math.abs(array[0] - value);
        int nearest = 0;
        for (int i = 1; i < array.length; ++i) {
            if (Math.abs(array[i] - value) >= diff) continue;
            diff = Math.abs(array[i] - value);
            nearest = i;
        }
        return nearest;
    }

    public static int nearestLowerElementValue(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int min = array[0];
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
            }
            if (value - array[ii] >= 0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int min = array[0];
        int minI = 0;
        while (test) {
            if (array[ii] < min) {
                min = array[ii];
                minI = ii;
            }
            if (value - array[ii] >= 0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min - value;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = value - array[i];
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static int nearestHigherElementValue(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int max = array[0];
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
            }
            if (array[ii] - value >= 0) {
                diff0 = value - array[ii];
                nearest = array[ii];
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = array[i];
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(int[] array, int value) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test = true;
        int max = array[0];
        int maxI = 0;
        while (test) {
            if (array[ii] > max) {
                max = array[ii];
                maxI = ii;
            }
            if (array[ii] - value >= 0) {
                diff0 = value - array[ii];
                nearest = ii;
                test = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value - max;
            test = false;
        }
        for (int i = 0; i < array.length; ++i) {
            diff1 = array[i] - value;
            if (diff1 < 0 || diff1 >= diff0) continue;
            diff0 = diff1;
            nearest = i;
        }
        return nearest;
    }

    public static double arraySum(double[] array) {
        double sum = 0.0;
        for (double i : array) {
            sum += i;
        }
        return sum;
    }

    public static float arraySum(float[] array) {
        float sum = 0.0f;
        for (float i : array) {
            sum += i;
        }
        return sum;
    }

    public static int arraySum(int[] array) {
        int sum = 0;
        for (int i : array) {
            sum += i;
        }
        return sum;
    }

    public static long arraySum(long[] array) {
        long sum = 0L;
        for (long i : array) {
            sum += i;
        }
        return sum;
    }

    public static long arrayPositiveElementsSum(long[] array) {
        long sum = 0L;
        for (long i : array) {
            if (i <= 0L) continue;
            sum += i;
        }
        return sum;
    }

    public static double arrayProduct(double[] array) {
        double product = 1.0;
        for (double i : array) {
            product *= i;
        }
        return product;
    }

    public static float arrayProduct(float[] array) {
        float product = 1.0f;
        for (float i : array) {
            product *= i;
        }
        return product;
    }

    public static int arrayProduct(int[] array) {
        int product = 1;
        for (int i : array) {
            product *= i;
        }
        return product;
    }

    public static long arrayProduct(long[] array) {
        long product = 1L;
        for (long i : array) {
            product *= i;
        }
        return product;
    }

    public static double[] concatenate(double[] aa, double[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        double[] cc = new double[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static float[] concatenate(float[] aa, float[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        float[] cc = new float[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static int[] concatenate(int[] aa, int[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        int[] cc = new int[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static long[] concatenate(long[] aa, long[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        long[] cc = new long[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static short[] concatenate(short[] aa, short[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        short[] cc = new short[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static byte[] concatenate(byte[] aa, byte[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        byte[] cc = new byte[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static char[] concatenate(char[] aa, char[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        char[] cc = new char[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static String[] concatenate(String[] aa, String[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        String[] cc = new String[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static Object[] concatenate(Object[] aa, Object[] bb) {
        int i;
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        Object[] cc = new Object[cLen];
        for (i = 0; i < aLen; ++i) {
            cc[i] = aa[i];
        }
        for (i = 0; i < bLen; ++i) {
            cc[i + aLen] = bb[i];
        }
        return cc;
    }

    public static double[] floatTOdouble(float[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] intTOdouble(int[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] intTOfloat(int[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] intTOlong(int[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] longTOdouble(long[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] longTOfloat(long[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] shortTOdouble(short[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] shortTOfloat(short[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] shortTOlong(short[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] shortTOint(short[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static double[] byteTOdouble(byte[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static float[] byteTOfloat(byte[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static long[] byteTOlong(byte[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] byteTOint(byte[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static short[] byteTOshort(byte[] aa) {
        int n = aa.length;
        short[] bb = new short[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        return bb;
    }

    public static int[] doubleTOint(double[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        for (int i = 0; i < n; ++i) {
            bb[i] = (int)aa[i];
        }
        return bb;
    }

    public static void print(double[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(double[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(float[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(float[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(int[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(int[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(long[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(long[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(char[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(char[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(String[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(String[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(short[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(short[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(byte[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i] + "   ");
        }
        System.out.println();
    }

    public static void println(byte[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i] + "   ");
        }
    }

    public static void print(double[][] aa) {
        for (int i = 0; i < aa.length; ++i) {
            Fmath.print(aa[i]);
        }
    }

    public static Vector<Object> selectSortVector(double[] aa) {
        ArrayList<Object> list = Fmath.selectSortArrayList(aa);
        Vector<Object> ret = null;
        if (list != null) {
            int n = list.size();
            ret = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                ret.addElement(list.get(i));
            }
        }
        return ret;
    }

    public static ArrayList<Object> selectSortArrayList(double[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        double holdb = 0.0;
        int holdi = 0;
        double[] bb = new double[n];
        int[] indices = new int[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
            indices[i] = i;
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            holdb = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index];
            indices[index] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        ArrayList<Object> arrayl = new ArrayList<Object>();
        arrayl.add(aa);
        arrayl.add(bb);
        arrayl.add(indices);
        return arrayl;
    }

    public static double[] selectionSort(double[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        double hold = 0.0;
        double[] bb = new double[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static float[] selectionSort(float[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        float hold = 0.0f;
        float[] bb = new float[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static int[] selectionSort(int[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int hold = 0;
        int[] bb = new int[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (bb[i] >= bb[index]) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static long[] selectionSort(long[] aa) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        long hold = 0L;
        long[] bb = new long[n];
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (bb[i] >= bb[index]) continue;
                index = i;
            }
            hold = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static void selectionSort(double[] aa, double[] bb, int[] indices) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        double holdb = 0.0;
        int holdi = 0;
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
            indices[i] = i;
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            holdb = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index];
            indices[index] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
    }

    public static void selectionSort(double[] aa, double[] bb, double[] cc, double[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        double holdy = 0.0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(cc[i] < cc[index])) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(float[] aa, float[] bb, float[] cc, float[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        float holdx = 0.0f;
        float holdy = 0.0f;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(cc[i] < cc[index])) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, long[] bb, long[] cc, long[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        long holdy = 0L;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, int[] bb, int[] cc, int[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        int holdy = 0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(double[] aa, long[] bb, double[] cc, long[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        long holdy = 0L;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(cc[i] < cc[index])) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, double[] bb, long[] cc, double[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        double holdy = 0.0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(double[] aa, int[] bb, double[] cc, int[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        int holdy = 0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(cc[i] < cc[index])) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, double[] bb, int[] cc, double[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        double holdy = 0.0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, int[] bb, long[] cc, int[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        int holdy = 0;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, long[] bb, int[] cc, long[] dd) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        long holdy = 0L;
        for (i = 0; i < n; ++i) {
            cc[i] = aa[i];
            dd[i] = bb[i];
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (cc[i] >= cc[index]) continue;
                index = i;
            }
            holdx = cc[index];
            cc[index] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index];
            dd[index] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectSort(double[] aa, double[] bb, int[] indices) {
        int i;
        int index = 0;
        int lastIndex = -1;
        int m = bb.length;
        int n = aa.length;
        if (m < n) {
            throw new IllegalArgumentException("The second argument array, bb, (length = " + m + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int k = indices.length;
        if (m < n) {
            throw new IllegalArgumentException("The third argument array, indices, (length = " + k + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        double holdb = 0.0;
        int holdi = 0;
        for (i = 0; i < n; ++i) {
            bb[i] = aa[i];
            indices[i] = i;
        }
        while (lastIndex != n - 1) {
            index = lastIndex + 1;
            for (i = lastIndex + 2; i < n; ++i) {
                if (!(bb[i] < bb[index])) continue;
                index = i;
            }
            holdb = bb[index];
            bb[index] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index];
            indices[index] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
    }

    public static double[] copy(double[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[] copy = new double[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static float[] copy(float[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[] copy = new float[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static int[] copy(int[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[] copy = new int[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static long[] copy(long[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[] copy = new long[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static double[][] copy(double[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][] copy = new double[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new double[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static float[][] copy(float[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][] copy = new float[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new float[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static int[][] copy(int[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][] copy = new int[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new int[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static long[][] copy(long[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][] copy = new long[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new long[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static double[][][] copy(double[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][][] copy = new double[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new double[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new double[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static float[][][] copy(float[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][][] copy = new float[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new float[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new float[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static int[][][] copy(int[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][][] copy = new int[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new int[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new int[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static long[][][] copy(long[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][][] copy = new long[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new long[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new long[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static double[][][][] copy(double[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][][][] copy = new double[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new double[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new double[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new double[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static float[][][][] copy(float[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][][][] copy = new float[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new float[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new float[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new float[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static int[][][][] copy(int[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][][][] copy = new int[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new int[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new int[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new int[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static long[][][][] copy(long[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][][][] copy = new long[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new long[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new long[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new long[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static String[] copy(String[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[] copy = new String[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static String[][] copy(String[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][] copy = new String[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new String[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static String[][][] copy(String[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][][] copy = new String[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new String[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new String[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static String[][][][] copy(String[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][][][] copy = new String[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new String[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new String[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new String[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static boolean[] copy(boolean[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[] copy = new boolean[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static boolean[][] copy(boolean[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][] copy = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new boolean[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static boolean[][][] copy(boolean[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][][] copy = new boolean[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new boolean[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new boolean[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static boolean[][][][] copy(boolean[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][][][] copy = new boolean[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new boolean[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new boolean[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new boolean[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static char[] copy(char[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[] copy = new char[n];
        for (int i = 0; i < n; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static char[][] copy(char[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][] copy = new char[n][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new char[m];
            for (int j = 0; j < m; ++j) {
                copy[i][j] = array[i][j];
            }
        }
        return copy;
    }

    public static char[][][] copy(char[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][][] copy = new char[n][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new char[m][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new char[l];
                for (int k = 0; k < l; ++k) {
                    copy[i][j][k] = array[i][j][k];
                }
            }
        }
        return copy;
    }

    public static char[][][][] copy(char[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][][][] copy = new char[n][][][];
        for (int i = 0; i < n; ++i) {
            int m = array[i].length;
            copy[i] = new char[m][][];
            for (int j = 0; j < m; ++j) {
                int l = array[i][j].length;
                copy[i][j] = new char[l][];
                for (int k = 0; k < l; ++k) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new char[ll];
                    for (int kk = 0; kk < ll; ++kk) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                    }
                }
            }
        }
        return copy;
    }

    public static Object copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return Fmath.copyObject(obj);
    }

    public static Object copyObject(Object obj) {
        if (obj == null) {
            return null;
        }
        Object objCopy = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            objCopy = ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return objCopy;
    }

    public static double radToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double frequencyToRadialFrequency(double frequency) {
        return Math.PI * 2 * frequency;
    }

    public static double radialFrequencyToFrequency(double radial) {
        return radial / (Math.PI * 2);
    }

    public static double evToNm(double ev) {
        return 2.99792458E17 / (-ev * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double nm) {
        return 2.99792458E8 / (-nm * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double molar, double molWeight) {
        return molar * molWeight / 10.0;
    }

    public static double percentWeightByVolToMolar(double perCent, double molWeight) {
        return perCent * 10.0 / molWeight;
    }

    public static double celsiusToKelvin(double cels) {
        return cels - -273.15;
    }

    public static double kelvinToCelsius(double kelv) {
        return kelv + -273.15;
    }

    public static double celsiusToFahren(double cels) {
        return cels * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double fahr) {
        return (fahr - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double cal) {
        return cal * 4.1868;
    }

    public static double jouleToCalorie(double joule) {
        return joule * 0.23884;
    }

    public static double gramToOunce(double gm) {
        return gm / 28.3459;
    }

    public static double ounceToGram(double oz) {
        return oz * 28.3459;
    }

    public static double kgToPound(double kg) {
        return kg / 0.4536;
    }

    public static double poundToKg(double pds) {
        return pds * 0.4536;
    }

    public static double kgToTon(double kg) {
        return kg / 1016.05;
    }

    public static double tonToKg(double tons) {
        return tons * 1016.05;
    }

    public static double millimetreToInch(double mm) {
        return mm / 25.4;
    }

    public static double inchToMillimetre(double in) {
        return in * 25.4;
    }

    public static double footToMetre(double ft) {
        return ft * 0.3048;
    }

    public static double metreToFoot(double metre) {
        return metre / 0.3048;
    }

    public static double yardToMetre(double yd) {
        return yd * 0.9144;
    }

    public static double metreToYard(double metre) {
        return metre / 0.9144;
    }

    public static double mileToKm(double mile) {
        return mile * 1.6093;
    }

    public static double kmToMile(double km) {
        return km / 1.6093;
    }

    public static double gallonToLitre(double gall) {
        return gall * 4.546;
    }

    public static double litreToGallon(double litre) {
        return litre / 4.546;
    }

    public static double quartToLitre(double quart) {
        return quart * 1.137;
    }

    public static double litreToQuart(double litre) {
        return litre / 1.137;
    }

    public static double pintToLitre(double pint) {
        return pint * 0.568;
    }

    public static double litreToPint(double litre) {
        return litre / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double gallPmile) {
        return gallPmile * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double litrePkm) {
        return litrePkm / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double milePgall) {
        return milePgall * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double kmPlitre) {
        return kmPlitre / 0.354;
    }

    public static double fluidOunceUKtoUS(double flOzUK) {
        return flOzUK * 0.961;
    }

    public static double fluidOunceUStoUK(double flOzUS) {
        return flOzUS * 1.041;
    }

    public static double pintUKtoUS(double pintUK) {
        return pintUK * 1.201;
    }

    public static double pintUStoUK(double pintUS) {
        return pintUS * 0.833;
    }

    public static double quartUKtoUS(double quartUK) {
        return quartUK * 1.201;
    }

    public static double quartUStoUK(double quartUS) {
        return quartUS * 0.833;
    }

    public static double gallonUKtoUS(double gallonUK) {
        return gallonUK * 1.201;
    }

    public static double gallonUStoUK(double gallonUS) {
        return gallonUS * 0.833;
    }

    public static double pintUKtoCupUS(double pintUK) {
        return pintUK / 0.417;
    }

    public static double cupUStoPintUK(double cupUS) {
        return cupUS * 0.417;
    }

    public static double calcBMImetric(double height, double weight) {
        return weight / (height * height);
    }

    public static double calcBMIimperial(double height, double weight) {
        height = Fmath.footToMetre(height);
        weight = Fmath.poundToKg(weight);
        return weight / (height * height);
    }

    public static double calcWeightFromBMImetric(double bmi, double height) {
        return bmi * height * height;
    }

    public static double calcWeightFromBMIimperial(double bmi, double height) {
        height = Fmath.footToMetre(height);
        double weight = bmi * height * height;
        weight = Fmath.kgToPound(weight);
        return weight;
    }

    static {
        integers.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        integers.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        integers.put(Byte.class, BigDecimal.valueOf(127L));
        integers.put(Short.class, BigDecimal.valueOf(32767L));
        integers.put(BigInteger.class, BigDecimal.valueOf(-1L));
    }
}

