/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSpline;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.QuadriCubicSpline;
import flanagan.interpolation.TriCubicSpline;
import flanagan.math.Fmath;
import java.lang.reflect.Array;

public class PolyCubicSpline {
    private int nDimensions = 0;
    private Object fOfX = null;
    private Object internalDeriv = null;
    private Object xArrays = null;
    private Object method = null;
    private double[][] xArray = null;
    private double[] csArray = null;
    private PolyCubicSpline[] pcs = null;
    private int dimOne = 0;
    private double yValue = 0.0;
    private double[] xMin = null;
    private double[] xMax = null;
    private boolean calculationDone = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public PolyCubicSpline(Object xArrays, Object fOfX) {
        this.fOfX = Fmath.copyObject(fOfX);
        this.xArrays = Fmath.copyObject(xArrays);
        Object internalArrays = Fmath.copyObject(fOfX);
        this.nDimensions = 1;
        while (!((internalArrays = Array.get(internalArrays, 0)) instanceof Double)) {
            ++this.nDimensions;
        }
        if (this.xArrays instanceof double[] && this.nDimensions == 1) {
            double[][] xArraysTemp = new double[][]{(double[])this.xArrays};
            this.xArrays = xArraysTemp;
        } else if (!(this.xArrays instanceof double[][])) {
            throw new IllegalArgumentException("xArrays should be a two dimensional array of doubles");
        }
        this.xArray = (double[][])this.xArrays;
        this.limits();
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                CubicSpline cs = new CubicSpline(this.xArray[0], (double[])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    cs.averageIdenticalAbscissae();
                }
                this.internalDeriv = cs.getDeriv();
                this.method = cs;
                this.calculationDone = true;
                break;
            }
            case 2: {
                BiCubicSpline bcs = new BiCubicSpline(this.xArray[0], this.xArray[1], (double[][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    bcs.averageIdenticalAbscissae();
                }
                this.internalDeriv = bcs.getDeriv();
                this.method = bcs;
                this.calculationDone = true;
                break;
            }
            case 3: {
                TriCubicSpline tcs = new TriCubicSpline(this.xArray[0], this.xArray[1], this.xArray[2], (double[][][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    tcs.averageIdenticalAbscissae();
                }
                this.internalDeriv = tcs.getDeriv();
                this.method = tcs;
                this.calculationDone = true;
                break;
            }
            case 4: {
                QuadriCubicSpline qcs = new QuadriCubicSpline(this.xArray[0], this.xArray[1], this.xArray[2], this.xArray[3], (double[][][][])this.fOfX);
                if (this.averageIdenticalAbscissae) {
                    qcs.averageIdenticalAbscissae();
                }
                this.internalDeriv = qcs.getDeriv();
                this.method = qcs;
                this.calculationDone = true;
                break;
            }
            default: {
                Object obj = fOfX;
                this.dimOne = Array.getLength(obj);
                this.csArray = new double[this.dimOne];
                double[][] newXarrays = new double[this.nDimensions - 1][];
                for (int i = 0; i < this.nDimensions - 1; ++i) {
                    newXarrays[i] = this.xArray[i + 1];
                }
                Object[] objDeriv = new Object[this.dimOne];
                if (this.calculationDone) {
                    objDeriv = (Object[])this.internalDeriv;
                }
                this.pcs = new PolyCubicSpline[this.dimOne];
                for (int i = 0; i < this.dimOne; ++i) {
                    Object objT = Array.get(obj, i);
                    this.pcs[i] = new PolyCubicSpline(newXarrays, objT);
                    if (this.averageIdenticalAbscissae) {
                        this.pcs[i].averageIdenticalAbscissae();
                    }
                    if (this.calculationDone) {
                        this.pcs[i].setDeriv(objDeriv[i]);
                    }
                    if (this.calculationDone) continue;
                    objDeriv[i] = this.pcs[i].getDeriv();
                }
                this.internalDeriv = objDeriv;
                this.calculationDone = true;
            }
        }
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        QuadriCubicSpline.noRoundingErrorCheck();
        TriCubicSpline.noRoundingErrorCheck();
        BiCubicSpline.noRoundingErrorCheck();
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        PolyCubicSpline.potentialRoundingError = potentialRoundingError;
        QuadriCubicSpline.potentialRoundingError(potentialRoundingError);
        TriCubicSpline.potentialRoundingError(potentialRoundingError);
        BiCubicSpline.potentialRoundingError(potentialRoundingError);
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    private void limits() {
        this.xMin = new double[this.nDimensions];
        this.xMax = new double[this.nDimensions];
        for (int i = 0; i < this.nDimensions; ++i) {
            this.xMin[i] = Fmath.minimum(this.xArray[i]);
            this.xMax[i] = Fmath.maximum(this.xArray[i]);
        }
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public int getNumberOfDimensions() {
        return this.nDimensions;
    }

    public double[] getLimits() {
        double[] limits = new double[2 * this.nDimensions];
        int j = 0;
        for (int i = 0; i < this.nDimensions; ++i) {
            limits[j] = this.xMin[i];
            limits[++j] = this.xMax[i];
            ++j;
        }
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < this.nDimensions; ++i) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
    }

    public double interpolate(double[] unknownCoord) {
        int nUnknown = unknownCoord.length;
        if (nUnknown != this.nDimensions) {
            throw new IllegalArgumentException("Number of unknown value coordinates, " + nUnknown + ", does not equal the number of tabulated data dimensions, " + this.nDimensions);
        }
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                this.yValue = ((CubicSpline)this.method).interpolate(unknownCoord[0]);
                break;
            }
            case 2: {
                this.yValue = ((BiCubicSpline)this.method).interpolate(unknownCoord[0], unknownCoord[1]);
                break;
            }
            case 3: {
                this.yValue = ((TriCubicSpline)this.method).interpolate(unknownCoord[0], unknownCoord[1], unknownCoord[2]);
                break;
            }
            case 4: {
                this.yValue = ((QuadriCubicSpline)this.method).interpolate(unknownCoord[0], unknownCoord[1], unknownCoord[2], unknownCoord[2]);
                break;
            }
            default: {
                int i;
                double[] newCoord = new double[this.nDimensions - 1];
                for (i = 0; i < this.nDimensions - 1; ++i) {
                    newCoord[i] = unknownCoord[i + 1];
                }
                for (i = 0; i < this.dimOne; ++i) {
                    this.csArray[i] = this.pcs[i].interpolate(newCoord);
                }
                CubicSpline ncs = new CubicSpline(this.xArray[0], this.csArray);
                this.yValue = ncs.interpolate(unknownCoord[0]);
            }
        }
        return this.yValue;
    }

    public void setDeriv(Object internalDeriv) {
        this.internalDeriv = internalDeriv;
    }

    public Object getDeriv() {
        return this.internalDeriv;
    }
}

